/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.ui.dialogs.StatusDialog;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.preferences.KeywordConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;

public class KeywordInputDialog
extends StatusDialog {
    private StringDialogField fNameDialogField;
    private List fExistingNames;

    public KeywordInputDialog(Shell parent, KeywordConfigurationBlock.Keyword task, List existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList(existingEntries.size());
        int i = 0;
        while (i < existingEntries.size()) {
            KeywordConfigurationBlock.Keyword curr = (KeywordConfigurationBlock.Keyword)existingEntries.get(i);
            if (!curr.equals(task)) {
                this.fExistingNames.add(curr.name);
            }
            ++i;
        }
        if (task == null) {
            this.setTitle(PreferencesMessages.KeywordInputDialog_new_title);
        } else {
            this.setTitle(PreferencesMessages.KeywordInputDialog_edit_title);
        }
        KeywordInputAdapter adapter = new KeywordInputAdapter();
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText(PreferencesMessages.KeywordInputDialog_name_label);
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText(task != null ? task.name : "");
    }

    public KeywordConfigurationBlock.Keyword getResult() {
        KeywordConfigurationBlock.Keyword task = new KeywordConfigurationBlock.Keyword();
        task.name = this.fNameDialogField.getText().trim();
        return task;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fNameDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), this.convertWidthInCharsToPixels(45));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        KeywordInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.KeywordInputDialog_error_enterName);
        } else if (newText.indexOf(44) != -1) {
            status.setError(PreferencesMessages.KeywordInputDialog_error_comma);
        } else if (this.fExistingNames.contains(newText)) {
            status.setError(PreferencesMessages.KeywordInputDialog_error_entryExists);
        } else if (Character.isWhitespace(newText.charAt(0)) || Character.isWhitespace(newText.charAt(newText.length() - 1))) {
            status.setError(PreferencesMessages.KeywordInputDialog_error_noSpace);
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private class KeywordInputAdapter
    implements IDialogFieldListener {
        private KeywordInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            KeywordInputDialog.this.doValidation();
        }
    }
}

