/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.preferences.KeywordInputDialog;
import org.rubypeople.rdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;

public class KeywordConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_COMPILER_TASK_TAGS = KeywordConfigurationBlock.getRDTUIKey("userDefinedKeywords");
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private IStatus fTaskTagsStatus;
    private ListDialogField fTodoTasksList;

    public KeywordConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, KeywordConfigurationBlock.getKeys(), container);
        KeywordAdapter adapter = new KeywordAdapter();
        String[] buttons = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_add_button, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_edit_button, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_remove_button};
        this.fTodoTasksList = new ListDialogField(adapter, buttons, (ILabelProvider)new KeywordLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(adapter);
        this.fTodoTasksList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_name_column};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.fTodoTasksList.setViewerSorter(new TodoTaskSorter());
        this.unpackTodoTasks();
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(1, false);
        }
        this.fTaskTagsStatus = new StatusInfo();
    }

    public void setEnabled(boolean isEnabled) {
        this.fTodoTasksList.setEnabled(isEnabled);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_COMPILER_TASK_TAGS};
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite markersComposite = this.createMarkersTabContent(parent);
        this.validateSettings(null, null, null);
        return markersComposite;
    }

    private Composite createMarkersTabContent(Composite folder) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)folder);
        Composite markersComposite = new Composite(folder, 0);
        markersComposite.setLayout((Layout)layout);
        markersComposite.setFont(folder.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fTodoTasksList.getListControl(markersComposite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fTodoTasksList.getButtonBox(markersComposite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        return markersComposite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (!PREF_COMPILER_TASK_TAGS.equals(changedKey)) return;
            this.fTaskTagsStatus = this.validateTaskTags();
        } else {
            this.fTaskTagsStatus = this.validateTaskTags();
        }
        IStatus status = this.fTaskTagsStatus;
        this.fContext.statusChanged(status);
    }

    private IStatus validateTaskTags() {
        return new StatusInfo();
    }

    protected final void updateModel(DialogField field) {
        if (field == this.fTodoTasksList) {
            StringBuffer tags = new StringBuffer();
            List list = this.fTodoTasksList.getElements();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    tags.append(',');
                }
                Keyword elem = (Keyword)list.get(i);
                tags.append(elem.name);
                ++i;
            }
            this.setValue(PREF_COMPILER_TASK_TAGS, tags.toString());
            this.validateSettings(PREF_COMPILER_TASK_TAGS, null, null);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected void updateControls() {
        this.unpackTodoTasks();
    }

    private void unpackTodoTasks() {
        String currTags = this.getValue(PREF_COMPILER_TASK_TAGS);
        String[] tags = this.getTokens(currTags, ",");
        ArrayList<Keyword> elements = new ArrayList<Keyword>(tags.length);
        int i = 0;
        while (i < tags.length) {
            Keyword task = new Keyword();
            task.name = tags[i].trim();
            elements.add(task);
            ++i;
        }
        this.fTodoTasksList.setElements(elements);
    }

    private void doTodoButtonPressed(int index) {
        KeywordInputDialog dialog;
        Keyword edited = null;
        if (index != 0) {
            edited = (Keyword)this.fTodoTasksList.getSelectedElements().get(0);
        }
        if ((index == 0 || index == 1) && (dialog = new KeywordInputDialog(this.getShell(), edited, this.fTodoTasksList.getElements())).open() == 0) {
            if (edited != null) {
                this.fTodoTasksList.replaceElement(edited, dialog.getResult());
            } else {
                this.fTodoTasksList.addElement(dialog.getResult());
            }
        }
    }

    public static class Keyword {
        public String name;
    }

    public class KeywordAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private boolean canEdit(List selectedElements) {
            return selectedElements.size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            KeywordConfigurationBlock.this.doTodoButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field.getSelectedElements())) {
                KeywordConfigurationBlock.this.doTodoButtonPressed(1);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            KeywordConfigurationBlock.this.updateModel(field);
        }
    }

    private class KeywordLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Keyword task = (Keyword)element;
            if (columnIndex == 0) {
                return task.name;
            }
            return "";
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    private static class TodoTaskSorter
    extends ViewerSorter {
        private TodoTaskSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.collator.compare(((Keyword)e1).name, ((Keyword)e2).name);
        }
    }
}

