/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.util.BusyIndicatorRunnableContext;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathsBlock;

public class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.rubypeople.rdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    public static final Object DATA_ADD_ENTRY = "add_classpath_entry";
    public static final Object DATA_REVEAL_ENTRY = "select_classpath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_classpath_attribute_key";
    public static final Object DATA_BLOCK = "block_until_buildpath_applied";
    private BuildPathsBlock fBuildPathsBlock;
    private boolean fBlockOnApply = false;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isRubyProject(project) ? this.createWithoutRuby(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithRuby(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    private IDialogSettings getSettings() {
        IDialogSettings javaSettings = RubyPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = javaSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = javaSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    public void setVisible(boolean visible) {
        if (this.fBuildPathsBlock != null) {
            if (!visible) {
                if (this.fBuildPathsBlock.hasChangesInDialog()) {
                    String title = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_title;
                    String message = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_message;
                    String[] buttonLabels = new String[]{PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_save, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_discard, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_ignore};
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                    int res = dialog.open();
                    if (res == 0) {
                        this.performOk();
                    } else if (res == 1) {
                        this.fBuildPathsBlock.init(RubyCore.create((IProject)this.getProject()), null, null);
                    }
                }
            } else if (!this.fBuildPathsBlock.hasChangesInDialog() && this.fBuildPathsBlock.hasChangesInLoadpathFile()) {
                this.fBuildPathsBlock.init(RubyCore.create((IProject)this.getProject()), null, null);
            }
        }
        super.setVisible(visible);
    }

    private Control createWithRuby(Composite parent, IProject project) {
        IWorkbenchPreferenceContainer pageContainer = null;
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            pageContainer = (IWorkbenchPreferenceContainer)container;
        }
        this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), this, this.getSettings().getInt(INDEX), false, pageContainer);
        this.fBuildPathsBlock.init(RubyCore.create((IProject)project), null, null);
        return this.fBuildPathsBlock.createControl(parent);
    }

    private Control createWithoutRuby(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_no_java_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_closed_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IRubyElement elem;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null && (elem = (IRubyElement)adaptable.getAdapter(IRubyElement.class)) instanceof IRubyProject) {
            return ((IRubyProject)elem).getProject();
        }
        return null;
    }

    private boolean isRubyProject(IProject proj) {
        try {
            return proj.hasNature("org.rubypeople.rdt.core.rubynature");
        }
        catch (CoreException e) {
            RubyPlugin.log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
            if (this.fBuildPathsBlock.hasChangesInDialog()) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                        BuildPathsPropertyPage.this.fBuildPathsBlock.configureRubyProject(monitor);
                    }
                };
                WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
                if (this.fBlockOnApply) {
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, this.getShell(), PreferencesMessages.BuildPathsPropertyPage_error_title, PreferencesMessages.BuildPathsPropertyPage_error_message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                } else {
                    op.runAsUserJob(PreferencesMessages.BuildPathsPropertyPage_job_title, null);
                }
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Object entryToAdd;
            Map map = (Map)data;
            Object selectedLibrary = map.get(DATA_REVEAL_ENTRY);
            if (selectedLibrary instanceof ILoadpathEntry) {
                String attributeKey;
                ILoadpathEntry entry = (ILoadpathEntry)selectedLibrary;
                Object attr = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
                String string = attributeKey = attr instanceof String ? (String)attr : null;
                if (this.fBuildPathsBlock != null) {
                    this.fBuildPathsBlock.setElementToReveal(entry, attributeKey);
                }
            }
            if ((entryToAdd = map.get(DATA_ADD_ENTRY)) instanceof ILoadpathEntry && this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.addElement((ILoadpathEntry)entryToAdd);
            }
            this.fBlockOnApply = Boolean.TRUE.equals(map.get(DATA_BLOCK));
        }
    }
}

