/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.dnd.RdtViewerDropAdapter;
import org.rubypeople.rdt.internal.ui.packageview.PackagesMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

public class SelectionTransferDropAdapter
extends RdtViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private int fCanMoveElements;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IRubyElement || target instanceof IResource;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fCanMoveElements = 0;
        this.fCanCopyElements = 0;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        if (this.tooFast(event)) {
            return;
        }
        this.initializeSelection();
        try {
            switch (operation) {
                case 16: {
                    event.detail = this.handleValidateDefault(target, event);
                    break;
                }
                case 1: {
                    event.detail = this.handleValidateCopy(target, event);
                    break;
                }
                case 2: {
                    event.detail = this.handleValidateMove(target, event);
                }
            }
        }
        catch (RubyModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            event.detail = 0;
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent event) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)event.time & 0xFFFFFFFFL)) < 150L;
    }

    public void drop(Object target, DropTargetEvent event) {
        try {
            try {
                switch (event.detail) {
                    case 2: {
                        this.handleDropMove(target, event);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target, event);
                    }
                }
            }
            catch (RubyModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
                event.detail = 0;
            }
            catch (InterruptedException interruptedException) {
                event.detail = 0;
            }
        }
        finally {
            event.detail = 0;
        }
    }

    private int handleValidateDefault(Object target, DropTargetEvent event) throws RubyModelException {
        if (target == null) {
            return 0;
        }
        if ((event.operations & 2) != 0) {
            return this.handleValidateMove(target, event);
        }
        if ((event.operations & 1) != 0) {
            return this.handleValidateCopy(target, event);
        }
        return 0;
    }

    private int handleValidateMove(Object target, DropTargetEvent event) throws RubyModelException {
        if (target == null) {
            return 0;
        }
        return 2;
    }

    private void handleDropMove(Object target, DropTargetEvent event) throws RubyModelException, InterruptedException {
        try {
            IRubyElement element;
            IResource blah;
            if (!(event.data instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)event.data;
            IResource resource = null;
            if (selection.getFirstElement() instanceof IResource) {
                resource = (IResource)selection.getFirstElement();
            } else if (selection.getFirstElement() instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)selection.getFirstElement();
                resource = (IResource)adaptable.getAdapter(IResource.class);
            }
            if (resource == null) {
                return;
            }
            IContainer container = null;
            if (target instanceof IContainer) {
                container = (IContainer)target;
            } else if (target instanceof IRubyElement && (blah = (element = (IRubyElement)target).getCorrespondingResource()) instanceof IContainer) {
                container = (IContainer)blah;
            }
            if (container == null) {
                return;
            }
            if (container.equals((Object)resource.getParent())) {
                return;
            }
            resource.move(container.getFullPath().append(resource.getName()), false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    private int handleValidateCopy(Object target, DropTargetEvent event) throws RubyModelException {
        return 1;
    }

    private void handleDropCopy(Object target, DropTargetEvent event) throws RubyModelException, InterruptedException {
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

