/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.infoviews;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.infoviews.InfoViewMessages;
import org.rubypeople.rdt.internal.ui.infoviews.RiUtility;
import org.rubypeople.rdt.internal.ui.rdocexport.RDocUtility;
import org.rubypeople.rdt.internal.ui.rdocexport.RdocListener;
import org.rubypeople.rdt.internal.ui.util.CollectionContentProvider;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIView
extends ViewPart
implements RdocListener,
IVMInstallChangedListener {
    private PageBook pageBook;
    private SashForm form;
    private Text searchStr;
    private TableViewer searchListViewer;
    private Browser searchResult;
    private static List<String> fgPossibleMatches = new ArrayList<String>();
    private IStructuredContentProvider contentProvider = new CollectionContentProvider();
    private RubyInvokerJob latestJob;
    private MyViewerFilter filter;
    private Timer timer;
    private Table searchTable;

    public RIView() {
        RubyRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void createPartControl(Composite parent) {
        this.contributeToActionBars();
        this.pageBook = new PageBook(parent, 0);
        Label inProgressLabel = new Label((Composite)this.pageBook, 16576);
        inProgressLabel.setText(InfoViewMessages.RubyInformation_please_wait);
        this.form = new SashForm((Composite)this.pageBook, 256);
        Composite panel = new Composite((Composite)this.form, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.timer = new Timer();
        this.searchStr = new Text(panel, 2176);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.searchStr.setLayoutData((Object)data);
        this.searchStr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RIView.this.timer != null) {
                    RIView.this.timer.cancel();
                }
                RIView.this.timer = new Timer();
                TimerTask task = new TimerTask(){

                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                RIView.this.filterSearchList();
                            }
                        });
                    }
                };
                RIView.this.timer.schedule(task, 500L);
            }
        });
        this.searchStr.setMessage("Enter class/method name");
        this.searchStr.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.keyCode == 0x1000002 || e.keyCode == 13) {
                    RIView.this.searchListViewer.getTable().setFocus();
                } else if (e.keyCode == 27) {
                    RIView.this.searchStr.setText("");
                }
            }
        });
        this.searchTable = new Table(panel, 0x10000B00);
        this.searchListViewer = new TableViewer(this.searchTable);
        this.searchListViewer.setContentProvider((IContentProvider)this.contentProvider);
        data = new GridData(1808);
        this.searchListViewer.getTable().setLayoutData((Object)data);
        this.searchListViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RIView.this.showSelectedItem();
            }
        });
        this.searchStr.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                RIView.this.searchStr.selectAll();
            }
        });
        this.filter = new MyViewerFilter();
        try {
            this.searchResult = new Browser((Composite)this.form, 2048);
            this.searchResult.setText("<html><body style=\"background-color: #000\"></body></html>");
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Unable to create embedded browser", (String)"It appears that you do not have an embeddable browser. Please see http://www.eclipse.org/swt/faq.php#browserlinux for more information if you are on Linux.");
        }
        this.form.setWeights(new int[]{1, 3});
        this.pageBook.showPage((Control)inProgressLabel);
        this.updatePage();
        RDocUtility.addRdocListener(this);
    }

    private void contributeToActionBars() {
        Action refreshAction = new Action(){

            public void run() {
                Job job = new Job("Refreshing RI View"){

                    public IStatus run(IProgressMonitor monitor) {
                        RiUtility.rebuildIndex();
                        RIView.this.updatePage();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        refreshAction.setText(InfoViewMessages.RubyInformation_refresh);
        refreshAction.setToolTipText(InfoViewMessages.RubyInformation_refresh_tooltip);
        refreshAction.setImageDescriptor(RubyPluginImages.TOOLBAR_REFRESH);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)refreshAction);
    }

    private void updatePage() {
        this.initSearchList();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                RIView.this.pageBook.showPage((Control)RIView.this.form);
            }
        });
    }

    private void showSelectedItem() {
        String searchText = (String)((IStructuredSelection)this.searchListViewer.getSelection()).getFirstElement();
        if (this.latestJob != null && this.latestJob.getState() != 0) {
            this.latestJob.cancel();
        }
        this.latestJob = new RubyInvokerJob(new RIDescriptionUpdater(searchText));
        this.latestJob.setPriority(10);
        this.latestJob.schedule();
    }

    public void dispose() {
        RDocUtility.removeRdocListener(this);
        RubyRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        this.filter = null;
        super.dispose();
    }

    private synchronized void initSearchList() {
        RIPopulator invoker = new RIPopulator();
        RubyInvokerJob job = new RubyInvokerJob(invoker);
        job.setPriority(30);
        job.schedule();
    }

    protected List<String> read(Reader reader) {
        HashSet<String> results;
        block15: {
            results = new HashSet<String>();
            BufferedReader reader2 = null;
            try {
                try {
                    reader2 = new BufferedReader(reader);
                    String line = null;
                    while ((line = reader2.readLine()) != null) {
                        results.add(line.trim());
                    }
                }
                catch (IOException e) {
                    RubyPlugin.log(e);
                    try {
                        if (reader2 != null) {
                            reader2.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader2 != null) {
                        reader2.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader2 != null) {
                    reader2.close();
                }
            }
            catch (IOException iOException) {}
        }
        ArrayList<String> list = new ArrayList<String>(results);
        Collections.sort(list);
        return list;
    }

    private void filterSearchList() {
        UIJob job = new UIJob("Filtering RI List"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                List<String> filtered = RIView.this.filter(RIView.this.searchStr.getText());
                RIView.this.searchTable.setItemCount(filtered.size());
                RIView.this.searchTable.clearAll();
                RIView.this.searchListViewer.setInput(filtered);
                if (RIView.this.searchTable.getItemCount() > 0) {
                    RIView.this.searchTable.setSelection(0);
                }
                if (RIView.this.searchTable.getItemCount() == 1) {
                    RIView.this.showSelectedItem();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected List<String> filter(String text) {
        this.filter.setText(text);
        ArrayList<String> filtered = new ArrayList<String>();
        for (String possible : fgPossibleMatches) {
            if (!this.filter.select(null, null, possible)) continue;
            filtered.add(possible);
        }
        return filtered;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    @Override
    public void rdocChanged() {
        this.updatePage();
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        this.updatePage();
    }

    public void vmAdded(IVMInstall newVm) {
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmRemoved(IVMInstall removedVm) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyViewerFilter
    extends ViewerFilter {
        private List<String> userTokens;

        private MyViewerFilter() {
        }

        public void setText(String value) {
            this.userTokens = value == null || value.trim().length() == 0 ? null : this.getTokens(value);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.userTokens == null) {
                return true;
            }
            String riEntry = (String)element;
            List<String> riListTokens = this.getTokens(riEntry);
            if (this.userTokens.size() == 1) {
                String userInput = this.userTokens.get(0);
                int i = 0;
                while (i < riListTokens.size()) {
                    if (riListTokens.get(i).startsWith(userInput)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            if (this.userTokens.size() > riListTokens.size()) {
                return false;
            }
            int i = 0;
            while (i < this.userTokens.size()) {
                if (!riListTokens.get(i).startsWith(this.userTokens.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private List<String> getTokens(String raw) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(raw, "::#");
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken().toLowerCase());
            }
            return tokens;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RIDescriptionUpdater
    extends RubyInvoker {
        private String searchValue;
        private final String HEADER = "<html><head></head><body style=\"color: #fff; background-color: #000\">";
        private final String TAIL = "</body></html>";
        private StringBuilder buffer;

        RIDescriptionUpdater(String value) {
            this.HEADER = "<html><head></head><body style=\"color: #fff; background-color: #000\">";
            this.TAIL = "</body></html>";
            this.searchValue = value;
        }

        @Override
        public void invoke() {
            String content = RiUtility.getRIHTMLContents(this.getArgList());
            if (content == null) {
                content = "";
            }
            this.handleOutput(content);
        }

        @Override
        protected List<String> getArgList() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.searchValue);
            return args;
        }

        @Override
        protected void beforeInvoke() {
            RIView.this.searchResult.setText(InfoViewMessages.RubyInformation_please_wait);
        }

        @Override
        protected void handleOutput(String content) {
            if (content == null) {
                return;
            }
            this.buffer = new StringBuilder();
            this.buffer.append(content);
            int index = this.buffer.indexOf("<body>");
            this.buffer.replace(index, index + 6, "<body style=\"color: #fff; background-color: #000\">");
            final String text = this.buffer.toString();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    RIView.this.searchResult.setText(text);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RIPopulator
    extends RubyInvoker {
        private RIPopulator() {
        }

        @Override
        public void invoke() {
            String content = RiUtility.getRIContents(this.getArgList());
            if (content == null) {
                content = "";
            }
            this.handleOutput(content);
        }

        @Override
        protected List<String> getArgList() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--no-pager");
            args.add("-l");
            return args;
        }

        @Override
        protected void handleOutput(String content) {
            if (content == null) {
                return;
            }
            new BufferedReader(new StringReader(content));
            fgPossibleMatches = RIView.this.read(new StringReader(content));
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RIView.this.searchListViewer.setInput((Object)fgPossibleMatches);
                    RIView.this.filterSearchList();
                    RIView.this.pageBook.showPage((Control)RIView.this.form);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class RubyInvoker {
        RubyInvoker() {
        }

        protected abstract List<String> getArgList();

        protected abstract void handleOutput(String var1);

        protected void beforeInvoke() {
        }

        public abstract void invoke();
    }

    private static class RubyInvokerJob
    extends Job {
        private RubyInvoker invoker;

        public RubyInvokerJob(RubyInvoker invoker) {
            super(InfoViewMessages.RubyInformation_update_job_title);
            this.invoker = invoker;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.invoker.invoke();
            return Status.OK_STATUS;
        }
    }
}

