/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDragAdapter
implements DragSourceListener {
    private TransferDragSourceListener[] fPossibleListeners;
    private List fActiveListeners;
    private TransferDragSourceListener fFinishListener;

    public DelegatingDragAdapter(TransferDragSourceListener[] listeners) {
        this.setPossibleListeners(listeners);
    }

    protected void setPossibleListeners(TransferDragSourceListener[] listeners) {
        Assert.isNotNull((Object)listeners);
        Assert.isTrue((this.fActiveListeners == null ? 1 : 0) != 0, (String)"Can only set possible listeners before drag operation has started");
        this.fPossibleListeners = listeners;
    }

    public void dragStart(DragSourceEvent event) {
        this.fFinishListener = null;
        boolean saveDoit = event.doit;
        Object saveData = event.data;
        boolean doIt = false;
        ArrayList<Transfer> transfers = new ArrayList<Transfer>(this.fPossibleListeners.length);
        this.fActiveListeners = new ArrayList(this.fPossibleListeners.length);
        int i = 0;
        while (i < this.fPossibleListeners.length) {
            TransferDragSourceListener listener = this.fPossibleListeners[i];
            event.doit = saveDoit;
            listener.dragStart(event);
            if (event.doit) {
                transfers.add(listener.getTransfer());
                this.fActiveListeners.add(listener);
            }
            doIt = doIt || event.doit;
            ++i;
        }
        if (doIt) {
            ((DragSource)event.widget).setTransfer(transfers.toArray(new Transfer[transfers.size()]));
        }
        event.data = saveData;
        event.doit = doIt;
    }

    public void dragSetData(DragSourceEvent event) {
        this.fFinishListener = this.getListener(event.dataType);
        if (this.fFinishListener != null) {
            this.fFinishListener.dragSetData(event);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        try {
            if (this.fFinishListener != null) {
                this.fFinishListener.dragFinished(event);
            } else {
                this.fFinishListener = this.getListener(event.dataType);
                if (this.fFinishListener != null) {
                    this.fFinishListener.dragFinished(event);
                }
            }
        }
        finally {
            this.fFinishListener = null;
            this.fActiveListeners = null;
        }
    }

    private TransferDragSourceListener getListener(TransferData type) {
        if (type == null) {
            return null;
        }
        for (TransferDragSourceListener listener : this.fActiveListeners) {
            if (!listener.getTransfer().isSupportedType(type)) continue;
            return listener;
        }
        return null;
    }
}

