/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.compare;

import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.compare.RubyCompareUtilities;
import org.rubypeople.rdt.internal.ui.compare.RubyNode;
import org.rubypeople.rdt.internal.ui.compare.RubyStructureCreator;

class RubyStructureDiffViewer
extends StructureDiffViewer {
    private static final String SMART = "SMART";
    private ActionContributionItem fSmartActionItem;
    private RubyStructureCreator fStructureCreator = new RubyStructureCreator();
    private boolean fThreeWay;

    public RubyStructureDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setStructureCreator(this.fStructureCreator);
    }

    protected void initialSelection() {
        Object[] children;
        DiffNode firstClass = null;
        Object o = this.getRoot();
        if (o != null && (children = this.getSortedChildren(o)) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                o = children[i];
                Object[] sortedChildren = this.getSortedChildren(o);
                if (sortedChildren != null && sortedChildren.length > 0) {
                    int j = 0;
                    while (j < sortedChildren.length) {
                        RubyNode jn;
                        int tc;
                        DiffNode dn;
                        ITypedElement e;
                        o = sortedChildren[j];
                        if (o instanceof DiffNode && (e = (dn = (DiffNode)o).getId()) instanceof RubyNode && ((tc = (jn = (RubyNode)e).getTypeCode()) == 5 || tc == 4)) {
                            firstClass = dn;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (firstClass != null) {
            this.expandToLevel(firstClass, 1);
        } else {
            this.expandToLevel(2);
        }
    }

    protected void compareInputChanged(ICompareInput input) {
        this.fThreeWay = input != null ? input.getAncestor() != null : false;
        this.setSmartButtonVisible(this.fThreeWay);
        if (input != null) {
            Map compilerOptions = this.getCompilerOptions(input.getAncestor());
            if (compilerOptions == null) {
                compilerOptions = this.getCompilerOptions(input.getLeft());
            }
            if (compilerOptions == null) {
                compilerOptions = this.getCompilerOptions(input.getRight());
            }
            if (compilerOptions != null) {
                this.fStructureCreator.setDefaultCompilerOptions(compilerOptions);
            }
        }
        super.compareInputChanged(input);
    }

    private Map getCompilerOptions(ITypedElement input) {
        IRubyProject javaProject;
        IRubyElement element;
        IResource resource;
        if (input instanceof IResourceProvider && (resource = ((IResourceProvider)input).getResource()) != null && (element = RubyCore.create((IResource)resource)) != null && (javaProject = element.getRubyProject()) != null) {
            return javaProject.getOptions(true);
        }
        return null;
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        ChangePropertyAction a = new ChangePropertyAction(this.getBundle(), this.getCompareConfiguration(), "action.Smart.", SMART);
        this.fSmartActionItem = new ActionContributionItem((IAction)a);
        this.fSmartActionItem.setVisible(this.fThreeWay);
        toolBarManager.appendToGroup("modes", (IContributionItem)this.fSmartActionItem);
    }

    protected void postDiffHook(Differencer differencer, IDiffContainer root) {
        boolean smart;
        if (this.fStructureCreator.canRewriteTree() && (smart = RubyCompareUtilities.getBoolean(this.getCompareConfiguration(), SMART, false)) && root != null) {
            this.fStructureCreator.rewriteTree(differencer, root);
        }
    }

    protected void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SMART)) {
            this.diff();
        } else {
            super.propertyChange(event);
        }
    }

    private void setSmartButtonVisible(boolean visible) {
        if (this.fSmartActionItem == null) {
            return;
        }
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        this.fSmartActionItem.setVisible(visible);
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)c.getParent());
        if (tbm != null) {
            tbm.update(true);
            ToolBar tb = tbm.getControl();
            if (!tb.isDisposed()) {
                tb.getParent().layout(true);
            }
        }
    }

    static class ChangePropertyAction
    extends Action {
        private CompareConfiguration fCompareConfiguration;
        private String fPropertyKey;
        private ResourceBundle fBundle;
        private String fPrefix;

        public ChangePropertyAction(ResourceBundle bundle, CompareConfiguration cc, String rkey, String pkey) {
            this.fPropertyKey = pkey;
            this.fBundle = bundle;
            this.fPrefix = rkey;
            RubyCompareUtilities.initAction((IAction)this, this.fBundle, this.fPrefix);
            this.setCompareConfiguration(cc);
        }

        public void run() {
            boolean b = !RubyCompareUtilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false);
            this.setChecked(b);
            if (this.fCompareConfiguration != null) {
                this.fCompareConfiguration.setProperty(this.fPropertyKey, (Object)new Boolean(b));
            }
        }

        public void setChecked(boolean state) {
            super.setChecked(state);
            RubyCompareUtilities.initToggleAction((IAction)this, this.fBundle, this.fPrefix, state);
        }

        public void setCompareConfiguration(CompareConfiguration cc) {
            this.fCompareConfiguration = cc;
            this.setChecked(RubyCompareUtilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false));
        }
    }
}

