/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.compare;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.compare.CompareMessages;
import org.rubypeople.rdt.internal.ui.compare.RubyCompareUtilities;
import org.rubypeople.rdt.internal.ui.compare.RubyNode;
import org.rubypeople.rdt.internal.ui.compare.RubyParseTreeBuilder;

public class RubyStructureCreator
implements IStructureCreator {
    private Map fDefaultCompilerOptions;

    void setDefaultCompilerOptions(Map compilerSettings) {
        this.fDefaultCompilerOptions = compilerSettings;
    }

    public String getName() {
        return CompareMessages.RubyStructureViewer_title;
    }

    public IStructureComparator getStructure(final Object input) {
        IRubyProject javaProject;
        IRubyElement element;
        IResource resource;
        String contents = null;
        char[] buffer = null;
        IDocument doc = CompareUI.getDocument((Object)input);
        if (doc == null) {
            if (input instanceof IStreamContentAccessor) {
                IStreamContentAccessor sca = (IStreamContentAccessor)input;
                try {
                    contents = RubyCompareUtilities.readString(sca);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            if (contents != null) {
                int n = contents.length();
                buffer = new char[n];
                contents.getChars(0, n, buffer, 0);
                doc = new Document(contents);
                RubyCompareUtilities.setupDocument(doc);
            }
        }
        Map compilerOptions = null;
        if (input instanceof IResourceProvider && (resource = ((IResourceProvider)input).getResource()) != null && (element = RubyCore.create((IResource)resource)) != null && (javaProject = element.getRubyProject()) != null) {
            compilerOptions = javaProject.getOptions(true);
        }
        if (compilerOptions == null) {
            compilerOptions = this.fDefaultCompilerOptions;
        }
        if (doc != null) {
            boolean isEditable = false;
            if (input instanceof IEditableContent) {
                isEditable = ((IEditableContent)input).isEditable();
            }
            RubyNode root = new RubyNode(doc, isEditable){

                void nodeChanged(RubyNode node) {
                    RubyStructureCreator.this.save((IStructureComparator)this, input);
                }
            };
            if (buffer == null) {
                contents = doc.get();
                int n = contents.length();
                buffer = new char[n];
                contents.getChars(0, n, buffer, 0);
            }
            try {
                RubyParser parser = new RubyParser();
                Node astRoot = parser.parse(new String(buffer)).getAST();
                astRoot.accept((NodeVisitor)new RubyParseTreeBuilder(root, buffer, true));
            }
            catch (Exception e) {
                RubyPlugin.log(e);
            }
            return root;
        }
        return null;
    }

    public boolean canSave() {
        return true;
    }

    public void save(IStructureComparator node, Object input) {
        if (node instanceof RubyNode && input instanceof IEditableContent) {
            byte[] bytes;
            IDocument document = ((RubyNode)node).getDocument();
            IEditableContent bca = (IEditableContent)input;
            String contents = document.get();
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                }
                catch (CoreException coreException) {}
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            try {
                bytes = contents.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = contents.getBytes();
            }
            bca.setContent(bytes);
        }
    }

    public String getContents(Object node, boolean ignoreWhiteSpace) {
        if (!(node instanceof IStreamContentAccessor)) {
            return null;
        }
        IStreamContentAccessor sca = (IStreamContentAccessor)node;
        String content = null;
        try {
            content = RubyCompareUtilities.readString(sca);
        }
        catch (CoreException ex) {
            RubyPlugin.log(ex);
            return null;
        }
        return content;
    }

    public boolean canRewriteTree() {
        return true;
    }

    public void rewriteTree(Differencer differencer, IDiffContainer root) {
        HashMap<String, RewriteInfo> map = new HashMap<String, RewriteInfo>(10);
        IDiffElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            DiffNode diff = (DiffNode)children[i];
            RubyNode jn = (RubyNode)diff.getId();
            if (jn != null) {
                int type = jn.getTypeCode();
                if (type == 11 || type == 10) {
                    String name = jn.extractMethodName();
                    RewriteInfo nameInfo = (RewriteInfo)map.get(name);
                    if (nameInfo == null) {
                        nameInfo = new RewriteInfo();
                        map.put(name, nameInfo);
                    }
                    nameInfo.add((IDiffElement)diff);
                    String argList = jn.extractArgumentList();
                    RewriteInfo argInfo = null;
                    if (argList != null && !argList.equals("()")) {
                        argInfo = (RewriteInfo)map.get(argList);
                        if (argInfo == null) {
                            argInfo = new RewriteInfo();
                            map.put(argList, argInfo);
                        }
                        argInfo.add((IDiffElement)diff);
                    }
                    switch (diff.getKind() & 3) {
                        case 1: 
                        case 2: {
                            if (type != 10) {
                                nameInfo.setDiff((ICompareInput)diff);
                            }
                            if (argInfo == null) break;
                            argInfo.setDiff((ICompareInput)diff);
                            break;
                        }
                    }
                }
                this.rewriteTree(differencer, (IDiffContainer)diff);
            }
            ++i;
        }
        for (String name : map.keySet()) {
            DiffNode d;
            RewriteInfo i2 = (RewriteInfo)map.get(name);
            if (!i2.matches() || (d = (DiffNode)differencer.findDifferences(true, null, (Object)root, (Object)i2.fAncestor, (Object)i2.fLeft, (Object)i2.fRight)) == null) continue;
            d.setDontExpand(true);
            for (IDiffElement rd : i2.fChildren) {
                root.removeToRoot(rd);
                d.add(rd);
            }
        }
    }

    public IStructureComparator locate(Object selector, Object input) {
        if (!(selector instanceof IRubyElement)) {
            return null;
        }
        IStructureComparator structure = this.getStructure(input);
        if (structure == null) {
            return null;
        }
        String[] path = RubyStructureCreator.createPath((IRubyElement)selector);
        return RubyStructureCreator.find(structure, path, 0);
    }

    private static String[] createPath(IRubyElement je) {
        ArrayList<String> args = new ArrayList<String>();
        while (je != null) {
            String name = RubyCompareUtilities.getRubyElementID(je);
            if (name == null) {
                return null;
            }
            args.add(name);
            if (je instanceof IRubyScript) break;
            je = je.getParent();
        }
        int n = args.size();
        String[] path = new String[n];
        int i = 0;
        while (i < n) {
            path[i] = (String)args.get(n - 1 - i);
            ++i;
        }
        return path;
    }

    private static IStructureComparator find(IStructureComparator tree, String[] path, int index) {
        Object[] children;
        if (tree != null && (children = tree.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IStructureComparator child = (IStructureComparator)children[i];
                if (child instanceof ITypedElement && child instanceof DocumentRangeNode) {
                    String n2;
                    String n1 = null;
                    if (child instanceof DocumentRangeNode) {
                        n1 = ((DocumentRangeNode)child).getId();
                    }
                    if (n1 == null) {
                        n1 = ((ITypedElement)child).getName();
                    }
                    if (n1.equals(n2 = path[index])) {
                        if (index == path.length - 1) {
                            return child;
                        }
                        IStructureComparator result = RubyStructureCreator.find(child, path, index + 1);
                        if (result != null) {
                            return result;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    static boolean hasEdition(IRubyElement je) {
        switch (je.getElementType()) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    static class RewriteInfo {
        boolean fIsOut = false;
        RubyNode fAncestor = null;
        RubyNode fLeft = null;
        RubyNode fRight = null;
        ArrayList fChildren = new ArrayList();

        RewriteInfo() {
        }

        void add(IDiffElement diff) {
            this.fChildren.add(diff);
        }

        void setDiff(ICompareInput diff) {
            if (this.fIsOut) {
                return;
            }
            this.fIsOut = true;
            RubyNode a = (RubyNode)diff.getAncestor();
            RubyNode y = (RubyNode)diff.getLeft();
            RubyNode m = (RubyNode)diff.getRight();
            if (a != null) {
                if (this.fAncestor != null) {
                    return;
                }
                this.fAncestor = a;
            }
            if (y != null) {
                if (this.fLeft != null) {
                    return;
                }
                this.fLeft = y;
            }
            if (m != null) {
                if (this.fRight != null) {
                    return;
                }
                this.fRight = m;
            }
            this.fIsOut = false;
        }

        boolean matches() {
            return !this.fIsOut && this.fAncestor != null && this.fLeft != null && this.fRight != null;
        }
    }
}

