/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.compare;

import java.util.Stack;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.StrNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ui.compare.RubyNode;

class RubyParseTreeBuilder
extends InOrderVisitor {
    private char[] fBuffer;
    private Stack fStack = new Stack();
    private boolean fShowCU;
    private RubyNode fImportContainer;

    public RubyParseTreeBuilder(RubyNode root, char[] buffer, boolean showCU) {
        this.fBuffer = buffer;
        this.fShowCU = showCU;
        this.fStack.clear();
        this.fStack.push(root);
    }

    private void pop() {
        this.fStack.pop();
    }

    private RubyNode getCurrentContainer() {
        return (RubyNode)((Object)this.fStack.peek());
    }

    private void push(int type, String name, int declarationStart, int length) {
        while (declarationStart > 0) {
            char c = this.fBuffer[declarationStart - 1];
            if (c != ' ' && c != '\t') break;
            --declarationStart;
            ++length;
        }
        RubyNode node = new RubyNode(this.getCurrentContainer(), type, name, declarationStart, length);
        if (type == 0) {
            node.setAppendPosition(declarationStart + length + 1);
        } else {
            node.setAppendPosition(declarationStart + length);
        }
        this.fStack.push(node);
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(5, ASTUtil.getFullyQualifiedName((Node)iVisited.getCPath()), start, end - start);
        Instruction ins = super.visitClassNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitSClassNode(SClassNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(5, ASTUtil.getNameReflectively((Node)iVisited.getReceiverNode()), start, end - start);
        Instruction ins = super.visitSClassNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(4, ASTUtil.getFullyQualifiedName((Node)iVisited.getCPath()), start, end - start);
        Instruction ins = super.visitModuleNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitRootNode(RootNode iVisited) {
        if (this.fShowCU) {
            this.push(0, null, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset());
        }
        Instruction ins = super.visitRootNode(iVisited);
        if (this.fShowCU) {
            this.pop();
        }
        return ins;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(11, iVisited.getName(), start, end - start);
        Instruction ins = super.visitDefnNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(11, iVisited.getName(), start, end - start);
        Instruction ins = super.visitDefsNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String name = iVisited.getName();
        this.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
        if (name.equals("require") || name.equals("load")) {
            this.addImport(iVisited);
        }
        return super.visitFCallNode(iVisited);
    }

    private void addImport(FCallNode iVisited) {
        ArrayNode node = (ArrayNode)iVisited.getArgsNode();
        String arg = this.getString(node);
        if (arg != null) {
            int s = node.getPosition().getStartOffset();
            int declarationEnd = node.getPosition().getEndOffset();
            int l = declarationEnd - s;
            if (this.fImportContainer == null) {
                this.fImportContainer = new RubyNode(this.getCurrentContainer(), 2, null, s, l);
            }
            new RubyNode(this.fImportContainer, 3, arg, s, l);
            this.fImportContainer.setLength(declarationEnd - this.fImportContainer.getRange().getOffset() + 1);
            this.fImportContainer.setAppendPosition(declarationEnd + 2);
        }
    }

    private String getString(ArrayNode node) {
        Object tmp = node.childNodes().iterator().next();
        if (tmp instanceof DStrNode) {
            DStrNode dstrNode = (DStrNode)tmp;
            tmp = dstrNode.childNodes().iterator().next();
        }
        if (tmp instanceof StrNode) {
            StrNode strNode = (StrNode)tmp;
            return strNode.getValue().toString();
        }
        return null;
    }

    public Instruction visitInstAsgnNode(InstAsgnNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(8, iVisited.getName(), start, end - start);
        Instruction ins = super.visitInstAsgnNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(8, iVisited.getName(), start, end - start);
        Instruction ins = super.visitClassVarDeclNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(8, iVisited.getName(), start, end - start);
        Instruction ins = super.visitClassVarAsgnNode(iVisited);
        this.pop();
        return ins;
    }

    public Instruction visitConstDeclNode(ConstDeclNode iVisited) {
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        this.push(8, iVisited.getName(), start, end - start);
        Instruction ins = super.visitConstDeclNode(iVisited);
        this.pop();
        return ins;
    }
}

