/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.commands;

import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;

public class RubyElementReferenceConverter
extends AbstractParameterValueConverter {
    private static final char PROJECT_END_CHAR = '/';
    private static final char TYPE_END_CHAR = '#';

    public Object convertToObject(String parameterValue) throws ParameterValueConversionException {
        this.assertWellFormed(parameterValue != null);
        int projectEndPosition = parameterValue.indexOf(47);
        this.assertWellFormed(projectEndPosition != -1);
        String projectName = parameterValue.substring(0, projectEndPosition);
        String javaElementRef = parameterValue.substring(projectEndPosition + 1);
        IRubyModel javaModel = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.assertExists((IRubyElement)javaModel);
        IRubyProject javaProject = javaModel.getRubyProject(projectName);
        this.assertExists((IRubyElement)javaProject);
        int typeEndPosition = javaElementRef.indexOf(35);
        String typeName = typeEndPosition == -1 ? javaElementRef : javaElementRef.substring(0, typeEndPosition);
        IType type = null;
        try {
            type = javaProject.findType(typeName);
        }
        catch (RubyModelException rubyModelException) {}
        this.assertExists((IRubyElement)type);
        if (typeEndPosition == -1) {
            return type;
        }
        String memberRef = javaElementRef.substring(typeEndPosition + 1);
        IField field = type.getField(memberRef);
        if (field != null && field.exists()) {
            return field;
        }
        String[] parameterTypes = null;
        IMethod method = type.getMethod(memberRef, parameterTypes);
        this.assertExists((IRubyElement)method);
        return method;
    }

    private void assertWellFormed(boolean assertion) throws ParameterValueConversionException {
        if (!assertion) {
            throw new ParameterValueConversionException("Malformed parameterValue");
        }
    }

    private void assertExists(IRubyElement javaElement) throws ParameterValueConversionException {
        if (javaElement == null || !javaElement.exists()) {
            throw new ParameterValueConversionException("parameterValue must reference an existing IRubyElement");
        }
    }

    public String convertToString(Object parameterValue) throws ParameterValueConversionException {
        StringBuffer buffer;
        if (!(parameterValue instanceof IRubyElement)) {
            throw new ParameterValueConversionException("parameterValue must be an IRubyElement");
        }
        IRubyElement javaElement = (IRubyElement)parameterValue;
        IRubyProject javaProject = javaElement.getRubyProject();
        if (javaProject == null) {
            throw new ParameterValueConversionException("Could not get IRubyProject for element");
        }
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            buffer = this.composeTypeReference(type);
        } else if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            buffer = this.composeTypeReference(method.getDeclaringType());
            buffer.append('#');
            buffer.append(method.getElementName());
        } else if (javaElement instanceof IField) {
            IField field = (IField)javaElement;
            buffer = this.composeTypeReference(field.getDeclaringType());
            buffer.append('#');
            buffer.append(field.getElementName());
        } else {
            throw new ParameterValueConversionException("Unsupported IRubyElement type");
        }
        return buffer.toString();
    }

    private StringBuffer composeTypeReference(IType type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(type.getRubyProject().getElementName());
        buffer.append('/');
        buffer.append(type.getFullyQualifiedName());
        return buffer;
    }
}

