/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchUtil;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

class SelectWorkingSetAction
extends Action {
    private final SearchScopeActionGroup fGroup;

    public SelectWorkingSetAction(SearchScopeActionGroup group) {
        super(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_search_scope_action_context");
    }

    public void run() {
        try {
            IWorkingSet[] workingSets = RubySearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets != null) {
                this.fGroup.setActiveWorkingSets(workingSets);
                SearchUtil.updateLRUWorkingSets(workingSets);
            } else {
                this.fGroup.setActiveWorkingSets(null);
            }
        }
        catch (RubyModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RubyPlugin.getActiveWorkbenchShell(), CallHierarchyMessages.SelectWorkingSetAction_error_title, CallHierarchyMessages.SelectWorkingSetAction_error_message);
        }
    }
}

