/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeAction;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;

class SearchScopeWorkingSetAction
extends SearchScopeAction {
    private IWorkingSet[] fWorkingSets;

    public SearchScopeWorkingSetAction(SearchScopeActionGroup group, IWorkingSet[] workingSets, String name) {
        super(group, name);
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_workingset_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_search_scope_action_context");
        this.fWorkingSets = workingSets;
    }

    public IRubySearchScope getSearchScope() {
        return RubySearchScopeFactory.getInstance().createRubySearchScope(this.fWorkingSets, true);
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSets;
    }

    public int getSearchScopeType() {
        return 4;
    }

    public String getFullDescription() {
        return RubySearchScopeFactory.getInstance().getWorkingSetScopeDescription(this.fWorkingSets, true);
    }
}

