/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;

class HistoryAction
extends Action {
    private static RubyElementLabelProvider fLabelProvider = new RubyElementLabelProvider(64);
    private CallHierarchyViewPart fView;
    private IMethod fMethod;

    public HistoryAction(CallHierarchyViewPart viewPart, IMethod element) {
        super("", 8);
        this.fView = viewPart;
        this.fMethod = element;
        String elementName = this.getElementLabel((IRubyElement)element);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor((IRubyElement)element));
        this.setDescription(Messages.format(CallHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(Messages.format(CallHierarchyMessages.HistoryAction_tooltip, elementName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_history_action_context");
    }

    private ImageDescriptor getImageDescriptor(IRubyElement elem) {
        RubyElementImageProvider imageProvider = new RubyElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fMethod);
    }

    private String getElementLabel(IRubyElement element) {
        Assert.isNotNull((Object)element);
        return fLabelProvider.getText(element);
    }
}

