/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.ui.ProblemsLabelDecorator;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

class TopLevelTypeProblemsLabelDecorator
extends ProblemsLabelDecorator {
    public TopLevelTypeProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        super(registry);
    }

    protected boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        if (!(sourceElement instanceof IType) || ((IType)sourceElement).getDeclaringType() != null) {
            return false;
        }
        IRubyScript cu = ((IType)sourceElement).getRubyScript();
        if (cu == null) {
            return false;
        }
        IType[] types = cu.getTypes();
        if (types.length < 1) {
            return false;
        }
        int firstTypeStartOffset = -1;
        ISourceRange range = types[0].getSourceRange();
        if (range != null) {
            firstTypeStartOffset = range.getOffset();
        }
        int lastTypeEndOffset = -1;
        range = types[types.length - 1].getSourceRange();
        if (range != null) {
            lastTypeEndOffset = range.getOffset() + range.getLength() - 1;
        }
        return pos < firstTypeStartOffset || pos > lastTypeEndOffset || this.isInside(pos, sourceElement.getSourceRange());
    }

    private boolean isInside(int pos, ISourceRange range) {
        if (range == null) {
            return false;
        }
        int offset = range.getOffset();
        return offset <= pos && pos < offset + range.getLength();
    }
}

