/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyUI;

public class RubyBrowsingPerspectiveFactory
implements IPerspectiveFactory {
    static IRubyElement fgRubyElementFromAction;

    public void createInitialLayout(IPageLayout layout) {
        if (this.stackBrowsingViewsVertically()) {
            this.createVerticalLayout(layout);
        } else {
            this.createHorizontalLayout(layout);
        }
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        layout.addActionSet("org.rubypeople.rdt.ui.rubyActionSet");
        layout.addActionSet("org.rubypeople.rdt.ui.RubyElementCreationActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addShowViewShortcut(RubyUI.ID_PROJECTS_VIEW);
        layout.addShowViewShortcut(RubyUI.ID_TYPES_VIEW);
        layout.addShowViewShortcut(RubyUI.ID_MEMBERS_VIEW);
        layout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        layout.addNewWizardShortcut("org.rubypeople.rdt.ui.wizards.RubyProjectWizard");
        layout.addNewWizardShortcut("org.rubypeople.rdt.ui.wizards.NewClassCreationWizard");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
    }

    private void createVerticalLayout(IPageLayout layout) {
        String relativePartId = "org.eclipse.ui.editorss";
        int relativePos = 1;
        IPlaceholderFolderLayout placeHolderLeft = layout.createPlaceholderFolder("left", 1, 0.25f, "org.eclipse.ui.editorss");
        placeHolderLeft.addPlaceholder("org.eclipse.ui.views.ContentOutline");
        placeHolderLeft.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        if (this.shouldShowProjectsView()) {
            layout.addView(RubyUI.ID_PROJECTS_VIEW, 1, 0.25f, "org.eclipse.ui.editorss");
            relativePartId = RubyUI.ID_PROJECTS_VIEW;
            relativePos = 4;
        }
        layout.addView(RubyUI.ID_TYPES_VIEW, relativePos, 0.33f, relativePartId);
        layout.addView(RubyUI.ID_MEMBERS_VIEW, 4, 0.5f, RubyUI.ID_TYPES_VIEW);
        IPlaceholderFolderLayout placeHolderBottom = layout.createPlaceholderFolder("bottom", 4, 0.75f, "org.eclipse.ui.editorss");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.ProblemView");
        placeHolderBottom.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.ProgressView");
    }

    private void createHorizontalLayout(IPageLayout layout) {
        String relativePartId = "org.eclipse.ui.editorss";
        int relativePos = 3;
        if (this.shouldShowProjectsView()) {
            layout.addView(RubyUI.ID_PROJECTS_VIEW, 3, 0.25f, "org.eclipse.ui.editorss");
            relativePartId = RubyUI.ID_PROJECTS_VIEW;
            relativePos = 2;
        }
        layout.addView(RubyUI.ID_TYPES_VIEW, relativePos, 0.33f, relativePartId);
        layout.addView(RubyUI.ID_MEMBERS_VIEW, 2, 0.5f, RubyUI.ID_TYPES_VIEW);
        IPlaceholderFolderLayout placeHolderLeft = layout.createPlaceholderFolder("left", 1, 0.25f, "org.eclipse.ui.editorss");
        placeHolderLeft.addPlaceholder("org.eclipse.ui.views.ContentOutline");
        placeHolderLeft.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        IPlaceholderFolderLayout placeHolderBottom = layout.createPlaceholderFolder("bottom", 4, 0.75f, "org.eclipse.ui.editorss");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.ProblemView");
        placeHolderBottom.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.ProgressView");
    }

    private boolean shouldShowProjectsView() {
        return fgRubyElementFromAction == null || fgRubyElementFromAction.getElementType() == 0;
    }

    private boolean stackBrowsingViewsVertically() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.rubypeople.rdt.ui.browsing.stackVertically");
    }

    static void setInputFromAction(IAdaptable input) {
        fgRubyElementFromAction = input instanceof IRubyElement ? (IRubyElement)input : null;
    }
}

