/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.CompositeActionGroup;
import org.rubypeople.rdt.internal.ui.actions.NewWizardsActionGroup;
import org.rubypeople.rdt.internal.ui.browsing.MembersView;
import org.rubypeople.rdt.internal.ui.browsing.PatchedOpenInNewWindowAction;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingContentProvider;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingMessages;
import org.rubypeople.rdt.internal.ui.browsing.RubyElementTypeComparator;
import org.rubypeople.rdt.internal.ui.browsing.ToggleLinkingAction;
import org.rubypeople.rdt.internal.ui.dnd.DelegatingDropAdapter;
import org.rubypeople.rdt.internal.ui.dnd.RdtViewerDragAdapter;
import org.rubypeople.rdt.internal.ui.packageview.ResourceTransferDragAdapter;
import org.rubypeople.rdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.rubypeople.rdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemTableViewer;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.StatusBarUpdater;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.RubyElementSorter;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;
import org.rubypeople.rdt.ui.actions.BuildActionGroup;
import org.rubypeople.rdt.ui.actions.CCPActionGroup;
import org.rubypeople.rdt.ui.actions.CustomFiltersActionGroup;
import org.rubypeople.rdt.ui.actions.OpenEditorActionGroup;
import org.rubypeople.rdt.ui.actions.OpenViewActionGroup;
import org.rubypeople.rdt.ui.actions.RubySearchActionGroup;

abstract class RubyBrowsingPart
extends ViewPart
implements ISelectionListener,
IMenuListener {
    private static final String TAG_SELECTED_ELEMENTS = "selectedElements";
    private static final String TAG_SELECTED_ELEMENT = "selectedElement";
    private static final String TAG_SELECTED_ELEMENT_PATH = "selectedElementPath";
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private RubyUILabelProvider fLabelProvider;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private ILabelProvider fTitleProvider;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private boolean fHasWorkingSetFilter = true;
    private boolean fHasCustomFilter = true;
    private OpenEditorActionGroup fOpenEditorGroup;
    protected CompositeActionGroup fActionGroups;
    private ToggleLinkingAction fToggleLinkingAction;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private RubyElementTypeComparator fTypeComparator;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == RubyBrowsingPart.this.getSite().getId()) {
                RubyBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage page = RubyBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (page != null) {
                    RubyBrowsingPart.this.selectionChanged(page.getActivePart(), page.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == RubyBrowsingPart.this.getSite().getId()) {
                RubyBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    private CCPActionGroup fCCPActionGroup;
    private BuildActionGroup fBuildActionGroup;

    public RubyBrowsingPart() {
        this.initLinkingEnabled();
    }

    protected void createActions() {
        ActionGroup[] actionGroupArray = new ActionGroup[6];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)this.getSite());
        this.fOpenEditorGroup = new OpenEditorActionGroup((IViewPart)this);
        actionGroupArray[1] = this.fOpenEditorGroup;
        actionGroupArray[2] = new OpenViewActionGroup((IViewPart)this);
        this.fCCPActionGroup = new CCPActionGroup((IViewPart)this);
        actionGroupArray[3] = this.fCCPActionGroup;
        this.fBuildActionGroup = new BuildActionGroup((IViewPart)this);
        actionGroupArray[4] = this.fBuildActionGroup;
        actionGroupArray[5] = new RubySearchActionGroup((IViewPart)this);
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        if (this.fHasWorkingSetFilter) {
            String viewId = this.getConfigurationElement().getAttribute("id");
            Assert.isNotNull((Object)viewId);
            IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    RubyBrowsingPart.this.doWorkingSetChanged(event);
                }
            };
            this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getSite(), workingSetListener);
            this.fViewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this, this.fViewer);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
    }

    protected void addFilters() {
    }

    protected void addKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                RubyBrowsingPart.this.handleKeyReleased(event);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent event) {
        IAction action;
        if (event.stateMask != 0) {
            return;
        }
        int key = event.keyCode;
        if (key == 0x100000E && (action = this.fBuildActionGroup.getRefreshAction()).isEnabled()) {
            action.run();
        }
    }

    protected void initDragAndDrop() {
        int ops = 7;
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter(this.fViewer)};
        this.fViewer.addDropSupport(ops | 0x10, dropTransfers, (DropTargetListener)new DelegatingDropAdapter(dropListeners));
        Transfer[] dragTransfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(ops, dragTransfers, (DragSourceListener)new RdtViewerDragAdapter(this.fViewer, dragListeners));
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetNameChange".equals(property)) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property)) {
            this.updateTitle();
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    protected void hookViewerListeners() {
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IAction open = RubyBrowsingPart.this.fOpenEditorGroup.getOpenAction();
                if (open.isEnabled()) {
                    open.run();
                    RubyBrowsingPart.this.restoreSelection();
                }
            }
        });
    }

    void setHasCustomSetFilter(boolean state) {
        this.fHasCustomFilter = state;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected void setCustomFiltersActionGroup(CustomFiltersActionGroup customFiltersActionGroup) {
        this.fCustomFiltersActionGroup = customFiltersActionGroup;
    }

    void restoreSelection() {
    }

    protected void setOpenEditorGroup(OpenEditorActionGroup openEditorGroup) {
        this.fOpenEditorGroup = openEditorGroup;
    }

    protected OpenEditorActionGroup getOpenEditorGroup() {
        return this.fOpenEditorGroup;
    }

    public void createPartControl(Composite parent) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fViewer = this.createViewer(parent);
        this.fTypeComparator = new RubyElementTypeComparator();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(this.fLabelProvider));
        this.fViewer.setSorter((ViewerSorter)this.createRubyElementSorter());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.hookViewerListeners();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.fillActionBars(this.getViewSite().getActionBars());
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager slManager) {
        return new StatusBarUpdater(slManager);
    }

    protected ILabelProvider createTitleProvider() {
        return new RubyElementLabelProvider(8);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(this.getLinkToEditorKey());
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    private void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTED_ELEMENTS);
            int i = 0;
            while (i < elements.length) {
                IMemento elementMem = selectionMem.createChild(TAG_SELECTED_ELEMENT);
                Object o = elements[i];
                if (o instanceof IRubyElement) {
                    elementMem.putString(TAG_SELECTED_ELEMENT_PATH, ((IRubyElement)elements[i]).getHandleIdentifier());
                }
                ++i;
            }
        }
    }

    protected void restoreState(IMemento memento) {
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    protected StructuredViewer createViewer(Composite parent) {
        return new ProblemTableViewer(parent);
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
        actionBars.updateActionBars();
        this.fActionGroups.fillActionBars(actionBars);
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        }
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.fToggleLinkingAction);
    }

    protected boolean hasWorkingSetFilter() {
        return this.fHasWorkingSetFilter;
    }

    protected void fillToolBar(IToolBarManager tbm) {
    }

    protected IContentProvider createContentProvider() {
        return new RubyBrowsingContentProvider(true, this);
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected void setInitialInput() {
        ISelection selection = this.getSite().getPage().getSelection();
        Object input = this.getSingleElementFromSelection(selection);
        if (!(input instanceof IRubyElement) && !((input = this.getSite().getPage().getInput()) instanceof IRubyElement) && input instanceof IAdaptable) {
            input = ((IAdaptable)input).getAdapter(IRubyElement.class);
        }
        this.setInput(this.findInputForRubyElement((IRubyElement)input));
    }

    protected RubyUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x210000000002L, 3);
    }

    protected void setInput(Object input) {
        this.setViewerInput(input);
        this.updateTitle();
    }

    void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? RubyElementLabels.getTextLabel(element, 0x210000000002L) : ((path = ((IResource)element).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : path.makeRelative().toString());
        if (this.fWorkingSetFilterActionGroup == null || this.fWorkingSetFilterActionGroup.getWorkingSet() == null) {
            return result;
        }
        IWorkingSet ws = this.fWorkingSetFilterActionGroup.getWorkingSet();
        String wsstr = Messages.format(RubyBrowsingMessages.RubyBrowsingPart_toolTip, new String[]{ws.getLabel()});
        if (result.length() == 0) {
            return wsstr;
        }
        return Messages.format(RubyBrowsingMessages.RubyBrowsingPart_toolTip2, new String[]{result, ws.getLabel()});
    }

    protected final void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    private void setViewerInput(Object input) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(input);
        this.fProcessSelectionEvents = true;
    }

    private boolean isSearchResultView(IWorkbenchPart part) {
        return RubyBrowsingPart.isSearchPlugInActivated() && (part instanceof ISearchResultView || part instanceof ISearchResultViewPart);
    }

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.fProcessSelectionEvents || part == this || this.isSearchResultView(part)) {
            if (part == this) {
                this.fPreviousSelectionProvider = part;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (this.fToggleLinkingAction.isChecked() && part instanceof ITextEditor) {
            this.setSelectionFromEditor(part, selection);
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selectedElement = this.getSingleElementFromSelection(selection);
        if (selectedElement != null && (part == null || part.equals(this.fPreviousSelectionProvider)) && selectedElement.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = selectedElement;
        Object currentInput = this.getViewer().getInput();
        if (selectedElement != null && selectedElement.equals(currentInput)) {
            IRubyElement elementToSelect = this.findElementToSelect(selectedElement);
            if (elementToSelect != null && this.getTypeComparator().compare(selectedElement, elementToSelect) < 0) {
                this.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
            } else if (elementToSelect == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (part != this.fPreviousSelectionProvider && selectedElement != null && !selectedElement.equals(currentInput) && this.isInputResetBy(selectedElement, currentInput, part)) {
            if (!this.isAncestorOf(selectedElement, currentInput)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selection.isEmpty() && !this.isInputResetBy(part)) {
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selectedElement == null && part == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = part;
            return;
        }
        this.fPreviousSelectionProvider = part;
        this.adjustInputAndSetSelection(selectedElement);
    }

    void setSelection(ISelection selection, boolean reveal) {
        if (selection != null && selection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(selection, reveal);
        this.fProcessSelectionEvents = true;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public Object getAdapter(Class key) {
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        return super.getAdapter(key);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, RubyBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    void adjustInputAndSetSelection(Object o) {
        if (!(o instanceof IRubyElement)) {
            if (o == null) {
                this.setInput(null);
            }
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        IRubyElement je = (IRubyElement)o;
        IRubyElement elementToSelect = this.getSuitableRubyElement(this.findElementToSelect(je));
        IRubyElement newInput = this.findInputForRubyElement(je);
        IRubyElement oldInput = null;
        if (this.getInput() instanceof IRubyElement) {
            oldInput = (IRubyElement)this.getInput();
        }
        if (elementToSelect == null && !this.isValidInput(newInput) && newInput == null && !this.isAncestorOf(je, oldInput)) {
            this.setInput(null);
        } else if (this.mustSetNewInput(elementToSelect, oldInput, newInput)) {
            this.setInput(newInput);
            elementToSelect = this.getSuitableRubyElement(elementToSelect);
        }
        if (elementToSelect != null && elementToSelect.exists()) {
            this.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    IRubyElement getSuitableRubyElement(Object obj) {
        if (!(obj instanceof IRubyElement)) {
            return null;
        }
        IRubyElement element = (IRubyElement)obj;
        if (this.fTypeComparator.compare((Object)element, 4) > 0) {
            return element;
        }
        if (this.isInputAWorkingCopy()) {
            IRubyElement wc = RubyBrowsingPart.getWorkingCopy(element);
            if (wc != null) {
                element = wc;
            }
            return element;
        }
        return element.getPrimaryElement();
    }

    boolean isInputAWorkingCopy() {
        return ((StandardRubyElementContentProvider)this.getViewer().getContentProvider()).getProvideWorkingCopy();
    }

    protected static IRubyElement getWorkingCopy(IRubyElement input) {
        return input;
    }

    private boolean mustSetNewInput(IRubyElement elementToSelect, IRubyElement oldInput, IRubyElement newInput) {
        if (newInput == null || !newInput.equals(oldInput)) {
            if (elementToSelect == null || oldInput != null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected Comparator getTypeComparator() {
        return this.fTypeComparator;
    }

    private boolean isInputResetBy(Object newInput, Object input, IWorkbenchPart part) {
        if (newInput == null) {
            return part == this.fPreviousSelectionProvider;
        }
        if (input instanceof IRubyElement && newInput instanceof IRubyElement) {
            return this.getTypeComparator().compare(newInput, input) > 0;
        }
        return false;
    }

    private boolean isInputResetBy(IWorkbenchPart part) {
        if (!(part instanceof RubyBrowsingPart)) {
            return true;
        }
        Object thisInput = this.getViewer().getInput();
        Object partInput = ((RubyBrowsingPart)part).getViewer().getInput();
        if (thisInput instanceof Collection) {
            thisInput = ((Collection)thisInput).iterator().next();
        }
        if (partInput instanceof Collection) {
            partInput = ((Collection)partInput).iterator().next();
        }
        if (thisInput instanceof IRubyElement && partInput instanceof IRubyElement) {
            return this.getTypeComparator().compare(partInput, thisInput) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object ancestor, Object element) {
        if (element instanceof IRubyElement && ancestor instanceof IRubyElement) {
            return !element.equals(ancestor) && this.internalIsAncestorOf((IRubyElement)ancestor, (IRubyElement)element);
        }
        return false;
    }

    private boolean internalIsAncestorOf(IRubyElement ancestor, IRubyElement element) {
        if (element != null) {
            return element.equals(ancestor) || this.internalIsAncestorOf(ancestor, element.getParent());
        }
        return false;
    }

    protected final IRubyElement findElementToSelect(Object obj) {
        if (obj instanceof IRubyElement) {
            return this.findElementToSelect((IRubyElement)obj);
        }
        return null;
    }

    protected abstract IRubyElement findElementToSelect(IRubyElement var1);

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final Object getSingleElementFromSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return null;
        }
        iter = ((StructuredSelection)selection).iterator();
        firstElement /* !! */  = iter.next();
        if (!(firstElement /* !! */  instanceof IRubyElement)) {
            if (firstElement /* !! */  instanceof IMarker) {
                firstElement /* !! */  = ((IMarker)firstElement /* !! */ ).getResource();
            }
            if (firstElement /* !! */  instanceof IAdaptable) {
                je = (IRubyElement)((IAdaptable)firstElement /* !! */ ).getAdapter(IRubyElement.class);
                if (je == null && firstElement /* !! */  instanceof IFile) {
                    parent = ((IFile)firstElement /* !! */ ).getParent();
                    if (parent != null) {
                        return (IRubyElement)parent.getAdapter(IRubyElement.class);
                    }
                    return null;
                }
                return je;
            }
            return firstElement /* !! */ ;
        }
        currentInput = this.getViewer().getInput();
        if (currentInput != null && currentInput.equals(this.findInputForRubyElement((IRubyElement)firstElement /* !! */ ))) ** GOTO lbl27
        if (iter.hasNext()) {
            return null;
        }
        return firstElement /* !! */ ;
lbl-1000:
        // 1 sources

        {
            element = iter.next();
            if (!(element instanceof IRubyElement)) {
                return null;
            }
            if (currentInput.equals(this.findInputForRubyElement((IRubyElement)element))) continue;
            return null;
lbl27:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl28:
        // 1 sources

        return firstElement /* !! */ ;
    }

    protected IRubyElement findInputForRubyElement(IRubyElement je) {
        if (je == null || !je.exists()) {
            return null;
        }
        if (this.isValidInput(je)) {
            return je;
        }
        return this.findInputForRubyElement(je.getParent());
    }

    protected RubyElementSorter createRubyElementSorter() {
        return new RubyElementSorter(){

            protected String getElementName(Object element) {
                if (element instanceof IType) {
                    IType type = (IType)element;
                    return type.getFullyQualifiedName();
                }
                return super.getElementName(element);
            }
        };
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean isValidElement(Object element) {
        if (element == null) {
            return false;
        }
        if ((element = this.getSuitableRubyElement(element)) == null) {
            return false;
        }
        Object input = this.getViewer().getInput();
        if (input == null) {
            return false;
        }
        if (input instanceof Collection) {
            return ((Collection)input).contains(element);
        }
        return input.equals(element);
    }

    protected DecoratingLabelProvider createDecoratingLabelProvider(RubyUILabelProvider provider) {
        return new DecoratingRubyLabelProvider(provider);
    }

    protected IType getTypeForRubyScript(IRubyScript script) {
        IType primaryType = (script = (IRubyScript)this.getSuitableRubyElement(script)).findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = script.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        super.dispose();
    }

    void setProcessSelectionEvents(boolean state) {
        this.fProcessSelectionEvents = state;
    }

    public void menuAboutToShow(IMenuManager menu) {
        RubyPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        if (size == 1) {
            this.addOpenNewWindowAction(menu, element);
        }
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof IRubyElement) {
            element = ((IRubyElement)element).getResource();
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new PatchedOpenInNewWindowAction(this.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.saveState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.saveState(memento);
        }
        this.saveSelectionState(memento);
        this.saveLinkingEnabled(memento);
    }

    void setHasWorkingSetFilter(boolean state) {
        this.fHasWorkingSetFilter = state;
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    protected void setInitialSelection() {
        IWorkbenchPart part;
        IWorkbenchPage page = this.getSite().getPage();
        ISelection selection = null;
        if (page != null) {
            selection = page.getSelection();
        }
        if (selection instanceof ITextSelection && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)part));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (selection == null || selection.isEmpty()) {
            selection = this.restoreSelectionState(this.fMemento);
        }
        if (selection == null || selection.isEmpty()) {
            Object input = this.getSite().getPage().getInput();
            if (!(input instanceof IRubyElement)) {
                if (input instanceof IAdaptable) {
                    input = input.getAdapter(IRubyElement.class);
                } else {
                    return;
                }
            }
            selection = new StructuredSelection(input);
        }
        this.selectionChanged(null, selection);
    }

    private ISelection restoreSelectionState(IMemento memento) {
        if (memento == null) {
            return null;
        }
        IMemento childMem = memento.getChild(TAG_SELECTED_ELEMENTS);
        if (childMem != null) {
            ArrayList<IRubyElement> list = new ArrayList<IRubyElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_SELECTED_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                String javaElementHandle = elementMem[i].getString(TAG_SELECTED_ELEMENT_PATH);
                IRubyElement element = RubyCore.create((String)javaElementHandle);
                if (element != null && element.exists()) {
                    list.add(element);
                }
                ++i;
            }
            return new StructuredSelection(list);
        }
        return null;
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue(this.getLinkToEditorKey(), enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    protected final ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final ILabelProvider getTitleProvider() {
        return this.fTitleProvider;
    }

    protected abstract String getLinkToEditorKey();

    void setSelectionFromEditor(IWorkbenchPart part) {
        if (!(this.fProcessSelectionEvents && this.linkBrowsingViewSelectionToEditor() && part instanceof IEditorPart)) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null) {
            this.setSelectionFromEditor(part, provider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            Object obj;
            IRubyElement element = null;
            if (selection instanceof IStructuredSelection && (obj = this.getSingleElementFromSelection(selection)) instanceof IRubyElement) {
                element = (IRubyElement)obj;
            }
            IEditorInput ei = ((IEditorPart)part).getEditorInput();
            if (selection instanceof ITextSelection) {
                int offset = ((ITextSelection)selection).getOffset();
                element = this.getElementAt(ei, offset);
            }
            if (element != null) {
                this.adjustInputAndSetSelection(element);
                return;
            }
            if (ei instanceof IFileEditorInput) {
                IContainer container;
                IFile file = ((IFileEditorInput)ei).getFile();
                IRubyElement je = (IRubyElement)file.getAdapter(IRubyElement.class);
                if (je == null && (container = ((IFileEditorInput)ei).getFile().getParent()) != null) {
                    je = (IRubyElement)container.getAdapter(IRubyElement.class);
                }
                if (je == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(je);
            }
        }
    }

    protected IRubyElement getElementAt(IEditorInput input, int offset) {
        WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
        IRubyScript unit = manager.getWorkingCopy(input);
        if (unit != null) {
            try {
                if (unit.isConsistent()) {
                    return unit.getElementAt(offset);
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        return null;
    }
}

