/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingContentProvider;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;

class ProjectAndSourceFolderContentProvider
extends RubyBrowsingContentProvider {
    ProjectAndSourceFolderContentProvider(RubyBrowsingPart browsingPart) {
        super(false, browsingPart);
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            this.startReadInDisplayThread();
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Class<?> clazz = null;
                for (Object item : (IStructuredSelection)element) {
                    if (clazz == null) {
                        clazz = item.getClass();
                    }
                    if (clazz == item.getClass()) {
                        result = ProjectAndSourceFolderContentProvider.concatenate(result, this.getChildren(item));
                        continue;
                    }
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    result = ProjectAndSourceFolderContentProvider.concatenate(result, this.getChildren(iter.next()));
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IRubyProject) {
                Object[] objectArray = this.getSourceFolderRoots((IRubyProject)element);
                return objectArray;
            }
            if (element instanceof ISourceFolderRoot) {
                Object[] objectArray = NO_CHILDREN;
                return objectArray;
            }
            Object[] objectArray = super.getChildren(element);
            return objectArray;
        }
        catch (RubyModelException rubyModelException) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    protected Object[] getSourceFolderRoots(IRubyProject project) throws RubyModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ISourceFolderRoot[] roots = project.getSourceFolderRoots();
        ArrayList<ISourceFolderRoot> list = new ArrayList<ISourceFolderRoot>(roots.length);
        int i = 0;
        while (i < roots.length) {
            ISourceFolderRoot root = roots[i];
            if (!this.isProjectSourceFolderRoot(root)) {
                list.add(root);
            }
            ++i;
        }
        return list.toArray();
    }

    public boolean hasChildren(Object element) {
        return element instanceof IRubyProject && super.hasChildren(element);
    }
}

