/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPerspectiveFactory;

public class PatchedOpenInNewWindowAction
extends OpenInNewWindowAction {
    private IWorkbenchWindow fWorkbenchWindow;

    public PatchedOpenInNewWindowAction(IWorkbenchWindow window, IAdaptable input) {
        super(window, input);
        this.fWorkbenchWindow = window;
    }

    public void run() {
        RubyBrowsingPerspectiveFactory.setInputFromAction((IAdaptable)this.getSelectedRubyElement());
        try {
            super.run();
        }
        finally {
            RubyBrowsingPerspectiveFactory.setInputFromAction(null);
        }
    }

    private IRubyElement getSelectedRubyElement() {
        ISelection selection;
        if (this.fWorkbenchWindow.getActivePage() != null && (selection = this.fWorkbenchWindow.getActivePage().getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof IRubyElement) {
                return (IRubyElement)selectedElement;
            }
            if (!(selectedElement instanceof IRubyElement) && selectedElement instanceof IAdaptable) {
                return (IRubyElement)((IAdaptable)selectedElement).getAdapter(IRubyElement.class);
            }
            if (selectedElement instanceof IWorkspace) {
                return RubyCore.create((IWorkspaceRoot)((IWorkspace)selectedElement).getRoot());
            }
        }
        return null;
    }
}

