/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.browsing.IPackagesViewViewer;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemTreeViewer;

public class PackagesViewTreeViewer
extends ProblemTreeViewer
implements IPackagesViewViewer {
    public PackagesViewTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void unmapElement(Object element) {
        super.unmapElement(element);
    }

    public void unmapElement(Object element, Widget item) {
        super.unmapElement(element, item);
    }

    public void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
    }

    protected Object[] getFilteredChildren(Object parent) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] result = this.getRawChildren(parent);
        if (result != null) {
            Object[] toBeFiltered = new Object[1];
            int i = 0;
            while (i < result.length) {
                Object object;
                toBeFiltered[0] = object = result[i];
                if (this.isEssential(object) || this.filter(toBeFiltered).length == 1) {
                    list.add(object);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    protected Object[] filter(Object[] elements) {
        ViewerFilter[] filters = this.getFilters();
        if (filters == null || filters.length == 0) {
            return elements;
        }
        ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
        Object root = this.getRoot();
        int i = 0;
        while (i < elements.length) {
            boolean add = true;
            if (!this.isEssential(elements[i])) {
                int j = 0;
                while (j < filters.length) {
                    add = filters[j].select((Viewer)this, root, elements[i]);
                    if (!add) break;
                    ++j;
                }
            }
            if (add) {
                filtered.add(elements[i]);
            }
            ++i;
        }
        return filtered.toArray();
    }

    public boolean isExpandable(Object parent) {
        Object[] children = ((ITreeContentProvider)this.getContentProvider()).getChildren(parent);
        Object[] toBeFiltered = new Object[1];
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (this.isEssential(object)) {
                return true;
            }
            toBeFiltered[0] = object;
            Object[] filtered = this.filter(toBeFiltered);
            if (filtered.length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEssential(Object object) {
        try {
            if (object instanceof ISourceFolder) {
                ISourceFolder fragment = (ISourceFolder)object;
                return !fragment.isDefaultPackage() && fragment.hasSubfolders();
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return false;
    }

    public Widget doFindItem(Object element) {
        return super.doFindItem(element);
    }

    public Widget doFindInputItem(Object element) {
        return super.doFindInputItem(element);
    }

    public List getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    public void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    public void internalRefresh(Object element) {
        super.internalRefresh(element);
    }

    public void setSelectionToWidget(List l, boolean reveal) {
        super.setSelectionToWidget(l, reveal);
    }
}

