/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class RubyWorkbenchAdapter
implements IWorkbenchAdapter {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private RubyElementImageProvider fImageProvider = new RubyElementImageProvider();

    public Object[] getChildren(Object element) {
        IRubyElement je = this.getRubyElement(element);
        if (je instanceof IParent) {
            try {
                return ((IParent)je).getChildren();
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IRubyElement je = this.getRubyElement(element);
        if (je != null) {
            return this.fImageProvider.getRubyImageDescriptor(je, 3);
        }
        return null;
    }

    public String getLabel(Object element) {
        return RubyElementLabels.getTextLabel(this.getRubyElement(element), RubyElementLabels.ALL_DEFAULT);
    }

    public Object getParent(Object element) {
        IRubyElement je = this.getRubyElement(element);
        return je != null ? je.getParent() : null;
    }

    private IRubyElement getRubyElement(Object element) {
        if (element instanceof IRubyElement) {
            return (IRubyElement)element;
        }
        if (element instanceof IRubyScriptEditorInput) {
            return ((IRubyScriptEditorInput)element).getRubyScript().getPrimaryElement();
        }
        return null;
    }
}

