/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyProjectLibraryPage {
    protected RubyProject workingProject;

    protected RubyProjectLibraryPage(RubyProject theWorkingProject) {
        this.workingProject = theWorkingProject;
    }

    protected Control getControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Table projectsTable = new Table(composite, 67618);
        projectsTable.setHeaderVisible(false);
        projectsTable.setLinesVisible(false);
        projectsTable.computeSize(-1, -1);
        TableColumn tableColumn = new TableColumn(projectsTable, 0);
        tableColumn.setWidth(200);
        tableColumn.setText(RubyUIMessages.RubyProjectLibraryPage_project);
        CheckboxTableViewer projectsTableViewer = new CheckboxTableViewer(projectsTable);
        projectsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RubyProjectLibraryPage.this.projectCheckedUnchecked(event);
            }
        });
        projectsTableViewer.setContentProvider(this.getContentProvider());
        projectsTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        projectsTableViewer.setInput(this.getWorkspaceProjects());
        ArrayList<IProject> referencedProjects = new ArrayList<IProject>();
        try {
            String[] names = this.workingProject.getRequiredProjectNames();
            int i = 0;
            while (i < names.length) {
                List<IProject> workspaceProjects = this.getWorkspaceProjects();
                for (IProject workspaceProject : workspaceProjects) {
                    if (!workspaceProject.getName().equals(names[i])) continue;
                    referencedProjects.add(workspaceProject);
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        projectsTableViewer.setCheckedElements(referencedProjects.toArray());
        return composite;
    }

    protected void projectCheckedUnchecked(CheckStateChangedEvent event) {
        IProject cfr_ignored_0 = (IProject)event.getElement();
        this.getWorkingProject();
    }

    protected RubyProject getWorkingProject() {
        return this.workingProject;
    }

    protected List<IProject> getWorkspaceProjects() {
        IWorkspaceRoot root = RubyPlugin.getWorkspace().getRoot();
        return Arrays.asList(root.getProjects());
    }

    protected ITableLabelProvider getLabelProvider() {
        ITableLabelProvider labelProvider = new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                IWorkbench workbench = RubyPlugin.getDefault().getWorkbench();
                return workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                return RubyUIMessages.RubyProjectLibraryPage_elementNotIProject;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        return labelProvider;
    }

    protected IContentProvider getContentProvider() {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            protected List rubyProjects;

            public Object[] getElements(Object inputElement) {
                return this.rubyProjects.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.rubyProjects = new ArrayList();
                if (!(newInput instanceof List)) {
                    return;
                }
                for (Object anObject : (List)newInput) {
                    IProject project;
                    if (!(anObject instanceof IProject) || (project = (IProject)anObject).getName() == RubyProjectLibraryPage.this.workingProject.getProject().getName()) continue;
                    try {
                        if (!project.hasNature("org.rubypeople.rdt.core.rubynature")) continue;
                        this.rubyProjects.add(project);
                    }
                    catch (CoreException coreException) {}
                }
            }
        };
        return contentProvider;
    }
}

