/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class RubyFileMatcher {
    private static final String RUBY = "ruby";
    private static final String SHEBANG = "#!";
    public static final int PROP_MATCH_CRITERIA = 1;
    private String[] rubyFileExtensions;
    private String[] rubyFileNames;
    private ListenerList propChangeListeners;
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if (property == 1 && source instanceof IEditorRegistry) {
                RubyFileMatcher.this.createFileExtensions();
                RubyFileMatcher.this.firePropertyChange(1);
            }
        }
    };
    private static Set RUBY_NON_EDITABLE_EXTENSIONS = new HashSet();

    static {
        RUBY_NON_EDITABLE_EXTENSIONS.add("yaml");
        RUBY_NON_EDITABLE_EXTENSIONS.add("yml");
        RUBY_NON_EDITABLE_EXTENSIONS.add("rhtml");
        RUBY_NON_EDITABLE_EXTENSIONS.add("gem");
        RUBY_NON_EDITABLE_EXTENSIONS.add("gemspec");
    }

    public RubyFileMatcher() {
        this.propChangeListeners = new ListenerList();
        this.createFileExtensions();
        WorkbenchPlugin.getDefault().getEditorRegistry().addPropertyListener(this.propertyListener);
    }

    public void addPropertyChangeListener(IPropertyListener propListener) {
        this.propChangeListeners.add((Object)propListener);
    }

    private void firePropertyChange(final int type) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged((Object)this, type);
                }
            });
            ++nX;
        }
    }

    public void createFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.addAll(this.createDefaultExtensions());
        ArrayList<String> filenames = new ArrayList<String>();
        filenames.addAll(this.createDefaultFilenames());
        IFileEditorMapping[] mappings = WorkbenchPlugin.getDefault().getEditorRegistry().getFileEditorMappings();
        int i = 0;
        while (i < mappings.length) {
            IFileEditorMapping mapping = mappings[i];
            IEditorDescriptor[] editors = mapping.getEditors();
            int j = 0;
            while (j < editors.length) {
                IEditorDescriptor descriptor = editors[j];
                if (descriptor.getId().equals("org.rubypeople.rdt.ui.EditorRubyFile")) {
                    if (mapping.getExtension() != null && mapping.getExtension().length() != 0) {
                        extensions.add(mapping.getExtension());
                        break;
                    }
                    if (mapping.getName() != null && mapping.getName().length() != 0) {
                        filenames.add(mapping.getName());
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.rubyFileExtensions = extensions.toArray(new String[extensions.size()]);
        this.rubyFileNames = filenames.toArray(new String[filenames.size()]);
    }

    private Collection createDefaultFilenames() {
        HashSet<String> set = new HashSet<String>();
        set.add("Rakefile");
        return set;
    }

    private Collection createDefaultExtensions() {
        return RUBY_NON_EDITABLE_EXTENSIONS;
    }

    public boolean hasRubyEditorAssociation(IFile file) {
        String fileExtension = file.getFileExtension();
        int i = 0;
        while (i < this.rubyFileExtensions.length) {
            if (this.rubyFileExtensions[i].equalsIgnoreCase(fileExtension)) {
                return true;
            }
            ++i;
        }
        String fileName = file.getName();
        int i2 = 0;
        while (i2 < this.rubyFileNames.length) {
            if (this.rubyFileNames[i2].equalsIgnoreCase(fileName)) {
                return true;
            }
            ++i2;
        }
        return this.containsRubyShebang(file);
    }

    private boolean containsRubyShebang(IFile file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(file.getContents()));
            String firstLine = reader.readLine();
            if (firstLine == null) {
                return false;
            }
            if (firstLine.indexOf(SHEBANG) > -1 && firstLine.indexOf(RUBY) > -1) {
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

