/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerPart;

public class RubyExplorerTracker
implements ISelectionChangedListener {
    private IProject currentlySelectedProject = null;
    private Set<IRubyProjectListener> projectListeners = new HashSet<IRubyProjectListener>();

    public void selectionChanged(SelectionChangedEvent event) {
        if (event == null) {
            return;
        }
        ISelection sel = event.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IProject inProject = RubyExplorerTracker.getProjectFromSelection(sel);
        if (inProject == null) {
            return;
        }
        if (!inProject.isOpen()) {
            this.setSelectedProject(null);
        } else {
            this.setSelectedProject(inProject);
        }
    }

    public void addProjectListener(IRubyProjectListener listener) {
        this.projectListeners.add(listener);
        listener.projectSelected(this.currentlySelectedProject);
    }

    public void removeProjectListener(IRubyProjectListener listener) {
        this.projectListeners.remove(listener);
    }

    private void notifyObservers() {
        for (IRubyProjectListener listener : this.projectListeners) {
            listener.projectSelected(this.currentlySelectedProject);
        }
    }

    private void setSelectedProject(IProject currentSelectedProject) {
        if (currentSelectedProject != this.currentlySelectedProject) {
            this.currentlySelectedProject = currentSelectedProject;
            this.notifyObservers();
        }
    }

    public IProject getSelectedProject() {
        return this.currentlySelectedProject;
    }

    public IProject getSelectedByNatureID(String natureId) {
        try {
            PackageExplorerPart part;
            if (this.currentlySelectedProject == null && (part = PackageExplorerPart.getFromActivePerspective()) != null) {
                ISelection selection = part.getSite().getSelectionProvider().getSelection();
                this.currentlySelectedProject = RubyExplorerTracker.getProjectFromSelection(selection);
            }
            if (this.currentlySelectedProject != null && this.currentlySelectedProject.hasNature(natureId)) {
                return this.currentlySelectedProject;
            }
        }
        catch (CoreException e) {
            RubyPlugin.log(4, "CoreException getting project nature for project: " + this.currentlySelectedProject.getName(), e);
        }
        return null;
    }

    private static IProject getProjectFromSelection(ISelection sel) {
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection == null || selection.getFirstElement() == null) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IRubyElement) {
            return ((IRubyElement)selection.getFirstElement()).getRubyProject().getProject();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getProject();
        }
        return null;
    }

    public IProject getSelectedRubyProject() {
        return this.getSelectedByNatureID("org.rubypeople.rdt.core.rubynature");
    }

    public static interface IRubyProjectListener {
        public void projectSelected(IProject var1);
    }
}

