/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.internal.corext.util.RubyElementResourceMapping;
import org.rubypeople.rdt.internal.ui.IResourceLocator;
import org.rubypeople.rdt.internal.ui.PersistableRubyElementFactory;
import org.rubypeople.rdt.internal.ui.ResourceLocator;
import org.rubypeople.rdt.internal.ui.RubyElementContainmentAdapter;
import org.rubypeople.rdt.internal.ui.RubyElementProperties;
import org.rubypeople.rdt.internal.ui.RubyTaskListAdapter;
import org.rubypeople.rdt.internal.ui.RubyWorkbenchAdapter;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.search.RubySearchPageScoreComputer;
import org.rubypeople.rdt.internal.ui.search.SearchUtil;

public class RubyElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter,
IContributorResourceAdapter2 {
    private static Class[] PROPERTIES = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    private Object fSearchPageScoreComputer;
    private static IResourceLocator fgResourceLocator;
    private static RubyWorkbenchAdapter fgRubyWorkbenchAdapter;
    private static ITaskListResourceAdapter fgTaskListAdapter;
    private static RubyElementContainmentAdapter fgRubyElementContainmentAdapter;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        this.updateLazyLoadedAdapters();
        IRubyElement java = this.getRubyElement(element);
        if (IPropertySource.class.equals((Object)key)) {
            return this.getProperties(java);
        }
        if (IResource.class.equals((Object)key)) {
            return this.getResource(java);
        }
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals((Object)key)) {
            return this.fSearchPageScoreComputer;
        }
        if (IWorkbenchAdapter.class.equals((Object)key)) {
            return RubyElementAdapterFactory.getRubyWorkbenchAdapter();
        }
        if (IResourceLocator.class.equals((Object)key)) {
            return RubyElementAdapterFactory.getResourceLocator();
        }
        if (IPersistableElement.class.equals((Object)key)) {
            return new PersistableRubyElementFactory(java);
        }
        if (IContributorResourceAdapter.class.equals((Object)key)) {
            return this;
        }
        if (IContributorResourceAdapter2.class.equals((Object)key)) {
            return this;
        }
        if (ITaskListResourceAdapter.class.equals((Object)key)) {
            return RubyElementAdapterFactory.getTaskListAdapter();
        }
        if (IContainmentAdapter.class.equals((Object)key)) {
            return RubyElementAdapterFactory.getRubyElementContainmentAdapter();
        }
        return null;
    }

    private IResource getResource(IRubyElement element) {
        switch (element.getElementType()) {
            case 5: {
                IRubyElement parent = element.getParent();
                if (parent instanceof IRubyScript) {
                    return ((IRubyScript)parent).getPrimary().getResource();
                }
                return null;
            }
            case 4: {
                return ((IRubyScript)element).getPrimary().getResource();
            }
            case 3: {
                ISourceFolderRoot root = (ISourceFolderRoot)element.getAncestor(2);
                if (!root.isExternal()) {
                    return element.getResource();
                }
                return null;
            }
            case 0: 
            case 1: 
            case 2: {
                return element.getResource();
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        IRubyElement je = this.getRubyElement(adaptable);
        if (je != null) {
            return this.getResource(je);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        IRubyElement je = this.getRubyElement(adaptable);
        if (je != null) {
            return RubyElementResourceMapping.create(je);
        }
        return null;
    }

    private IRubyElement getRubyElement(Object element) {
        if (element instanceof IRubyElement) {
            return (IRubyElement)element;
        }
        if (element instanceof IRubyScriptEditorInput) {
            return ((IRubyScriptEditorInput)element).getRubyScript().getPrimaryElement();
        }
        return null;
    }

    private IPropertySource getProperties(IRubyElement element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return new RubyElementProperties(element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new RubySearchPageScoreComputer();
        PROPERTIES = new Class[]{IPropertySource.class, IResource.class, ISearchPageScoreComputer.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IProject.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    }

    private static IResourceLocator getResourceLocator() {
        if (fgResourceLocator == null) {
            fgResourceLocator = new ResourceLocator();
        }
        return fgResourceLocator;
    }

    private static RubyWorkbenchAdapter getRubyWorkbenchAdapter() {
        if (fgRubyWorkbenchAdapter == null) {
            fgRubyWorkbenchAdapter = new RubyWorkbenchAdapter();
        }
        return fgRubyWorkbenchAdapter;
    }

    private static ITaskListResourceAdapter getTaskListAdapter() {
        if (fgTaskListAdapter == null) {
            fgTaskListAdapter = new RubyTaskListAdapter();
        }
        return fgTaskListAdapter;
    }

    private static RubyElementContainmentAdapter getRubyElementContainmentAdapter() {
        if (fgRubyElementContainmentAdapter == null) {
            fgRubyElementContainmentAdapter = new RubyElementContainmentAdapter();
        }
        return fgRubyElementContainmentAdapter;
    }
}

