/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.ToolFactory;
import org.rubypeople.rdt.internal.corext.Assert;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class CodeFormatterUtil {
    public static TextEdit format2(int kind, String string, int offset, int length, int indentationLevel, String lineSeparator, Map options) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + string.length());
        }
        return ToolFactory.createCodeFormatter((Map)options).format(kind, string, offset, length, indentationLevel, lineSeparator);
    }

    public static int getIndentWidth(IRubyProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.rubypeople.rdt.core.formatter.tabulation.char")) ? "org.rubypeople.rdt.core.formatter.indentation.size" : "org.rubypeople.rdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getTabWidth(IRubyProject project) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(project, "org.rubypeople.rdt.core.formatter.tabulation.char")) ? "org.rubypeople.rdt.core.formatter.indentation.size" : "org.rubypeople.rdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    private static String getCoreOption(IRubyProject project, String key) {
        if (project == null) {
            return RubyCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private static int getCoreOption(IRubyProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static String createIndentString(int indentationUnits, IRubyProject project) {
        int spaces;
        int tabs;
        String tabChar = CodeFormatterUtil.getCoreOption(project, "org.rubypeople.rdt.core.formatter.tabulation.char");
        if ("space".equals(tabChar)) {
            tabs = 0;
            spaces = indentationUnits * CodeFormatterUtil.getIndentWidth(project);
        } else if ("tab".equals(tabChar)) {
            tabs = indentationUnits;
            spaces = 0;
        } else if ("mixed".equals(tabChar)) {
            int tabWidth = CodeFormatterUtil.getTabWidth(project);
            int spaceEquivalents = indentationUnits * CodeFormatterUtil.getIndentWidth(project);
            if (tabWidth > 0) {
                tabs = spaceEquivalents / tabWidth;
                spaces = spaceEquivalents % tabWidth;
            } else {
                tabs = 0;
                spaces = spaceEquivalents;
            }
        } else {
            Assert.isTrue(false);
            return null;
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public static TextEdit format2(int kind, String string, int indentationLevel, String lineSeparator, Map options) {
        return CodeFormatterUtil.format2(kind, string, 0, string.length(), indentationLevel, lineSeparator, options);
    }

    public static String format(int kind, String string, int offset, int length, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        TextEdit edit = CodeFormatterUtil.format2(kind, string, offset, length, indentationLevel, lineSeparator, options);
        if (edit == null) {
            return string.substring(offset, offset + length);
        }
        String formatted = CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
        return formatted.substring(offset, formatted.length() - (string.length() - (offset + length)));
    }

    private static String getOldAPICompatibleResult(String string, TextEdit edit, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        Position[] p = null;
        if (positions != null) {
            p = new Position[positions.length];
            int i = 0;
            while (i < positions.length) {
                p[i] = new Position(positions[i], 0);
                ++i;
            }
        }
        String res = CodeFormatterUtil.evaluateFormatterEdit(string, edit, p);
        if (positions != null) {
            int i = 0;
            while (i < positions.length) {
                Position curr = p[i];
                positions[i] = curr.getOffset();
                ++i;
            }
        }
        return res;
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = CodeFormatterUtil.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                int i = 0;
                while (i < positions.length) {
                    Assert.isTrue(!positions[i].isDeleted, "Position got deleted");
                    ++i;
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            RubyPlugin.log(e);
            Assert.isTrue(false, "Formatter created edits with wrong positions: " + e.getMessage());
            return null;
        }
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int i = 0;
                while (i < positions.length) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return doc;
    }

    public static String format(int kind, String string, int indentationLevel, int[] positions, String lineSeparator, IRubyProject project) {
        Map options = project != null ? project.getOptions(true) : null;
        return CodeFormatterUtil.format(kind, string, 0, string.length(), indentationLevel, positions, lineSeparator, options);
    }
}

