/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.jruby.ast.Node;

public class Selection {
    public static final int INTERSECTS = 0;
    public static final int BEFORE = 1;
    public static final int SELECTED = 2;
    public static final int AFTER = 3;
    private int fStart;
    private int fLength;
    private int fExclusiveEnd;

    protected Selection() {
    }

    public static Selection createFromStartLength(int s, int l) {
        Assert.isTrue((s >= 0 && l >= 0 ? 1 : 0) != 0);
        Selection result = new Selection();
        result.fStart = s;
        result.fLength = l;
        result.fExclusiveEnd = s + l;
        return result;
    }

    public static Selection createFromStartEnd(int s, int e) {
        Assert.isTrue((s >= 0 && e >= s ? 1 : 0) != 0);
        Selection result = new Selection();
        result.fStart = s;
        result.fLength = e - s + 1;
        result.fExclusiveEnd = result.fStart + result.fLength;
        return result;
    }

    public int getOffset() {
        return this.fStart;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getInclusiveEnd() {
        return this.fExclusiveEnd - 1;
    }

    public int getExclusiveEnd() {
        return this.fExclusiveEnd;
    }

    public int getVisitSelectionMode(Node node) {
        int nodeStart = node.getPosition().getStartOffset();
        int nodeEnd = node.getPosition().getEndOffset();
        if (nodeEnd <= this.fStart) {
            return 1;
        }
        if (this.covers(node)) {
            return 2;
        }
        if (this.fExclusiveEnd <= nodeStart) {
            return 3;
        }
        return 0;
    }

    public int getEndVisitSelectionMode(Node node) {
        node.getPosition().getStartOffset();
        int nodeEnd = node.getPosition().getEndOffset();
        if (nodeEnd <= this.fStart) {
            return 1;
        }
        if (this.covers(node)) {
            return 2;
        }
        if (nodeEnd >= this.fExclusiveEnd) {
            return 3;
        }
        return 0;
    }

    public boolean covers(int position) {
        return this.fStart <= position && position < this.fStart + this.fLength;
    }

    public boolean covers(Node node) {
        int nodeStart = node.getPosition().getStartOffset();
        return this.fStart <= nodeStart && node.getPosition().getEndOffset() <= this.fExclusiveEnd;
    }

    public boolean coveredBy(Node node) {
        int nodeStart = node.getPosition().getStartOffset();
        return nodeStart <= this.fStart && this.fExclusiveEnd <= node.getPosition().getEndOffset();
    }

    public boolean coveredBy(IRegion region) {
        int rangeStart = region.getOffset();
        return rangeStart <= this.fStart && this.fExclusiveEnd <= rangeStart + region.getLength();
    }

    public boolean endsIn(Node node) {
        int nodeStart = node.getPosition().getStartOffset();
        return nodeStart < this.fExclusiveEnd && this.fExclusiveEnd < node.getPosition().getEndOffset();
    }

    public boolean liesOutside(Node node) {
        boolean selectionBeforeNode;
        int nodeStart = node.getPosition().getStartOffset();
        int nodeEnd = node.getPosition().getEndOffset();
        boolean nodeBeforeSelection = nodeEnd < this.fStart;
        boolean bl = selectionBeforeNode = this.fExclusiveEnd < nodeStart;
        return nodeBeforeSelection || selectionBeforeNode;
    }

    public String toString() {
        return "<start == " + this.fStart + ", length == " + this.fLength + "/>";
    }
}

