/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.callhierarchy;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.callhierarchy.IImplementorFinder;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyImplementorFinder
implements IImplementorFinder {
    public Collection findImplementingTypes(IType type, IProgressMonitor progressMonitor) {
        try {
            ITypeHierarchy typeHierarchy = type.newTypeHierarchy(progressMonitor);
            IType[] implementingTypes = typeHierarchy.getAllClasses();
            HashSet result = new HashSet(Arrays.asList(implementingTypes));
            return result;
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
            return null;
        }
    }

    public Collection findInterfaces(IType type, IProgressMonitor progressMonitor) {
        try {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
            IType[] interfaces = typeHierarchy.getAllSuperModules(type);
            HashSet result = new HashSet(Arrays.asList(interfaces));
            return result;
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
            return null;
        }
    }
}

