/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.callhierarchy;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallSearchResultCollector;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

class CalleeAnalyzerVisitor
extends InOrderVisitor {
    private IMethod fMethod;
    private CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
    private IProgressMonitor fProgressMonitor;
    private int fMethodStartPosition;
    private int fMethodEndPosition;

    public CalleeAnalyzerVisitor(IMethod method, IProgressMonitor progressMonitor) {
        this.fMethod = method;
        this.fProgressMonitor = progressMonitor;
        try {
            ISourceRange sourceRange = method.getSourceRange();
            this.fMethodStartPosition = sourceRange.getOffset();
            this.fMethodEndPosition = this.fMethodStartPosition + sourceRange.getLength();
        }
        catch (RubyModelException jme) {
            RubyPlugin.log(jme);
        }
    }

    private void addMethodCall(ISourcePosition pos) {
        int offset = pos.getStartOffset();
        int endOffset = pos.getEndOffset();
        int length = endOffset - offset;
        try {
            IRubyElement[] elements = this.fMethod.getRubyScript().codeSelect(offset, length);
            if (elements == null) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IMember) {
                    IMember member = (IMember)elements[i];
                    this.fSearchResults.addMember((IMember)this.fMethod, member, offset, endOffset, pos.getStartLine());
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    public Map getCallees() {
        return this.fSearchResults.getCallers();
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        if (this.isNodeWithinMethod((Node)iVisited)) {
            this.addMethodCall(iVisited.getPosition());
        }
        return super.visitVCallNode(iVisited);
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        if (this.isNodeWithinMethod((Node)iVisited)) {
            this.addMethodCall(iVisited.getPosition());
        }
        return super.visitFCallNode(iVisited);
    }

    public Instruction visitCallNode(CallNode iVisited) {
        if (this.isNodeWithinMethod((Node)iVisited)) {
            if (iVisited.getName().equals("[]")) {
                return super.visitCallNode(iVisited);
            }
            String receiver = ASTUtil.stringRepresentation((Node)iVisited.getReceiverNode());
            ISourcePosition original = iVisited.getPosition();
            int start = original.getStartOffset() + receiver.length() + 1;
            IDESourcePosition pos = new IDESourcePosition(original.getFile(), original.getStartLine(), original.getEndLine(), start, original.getEndOffset());
            this.addMethodCall((ISourcePosition)pos);
        }
        return super.visitCallNode(iVisited);
    }

    private boolean isNodeWithinMethod(Node node) {
        int nodeStartPosition = node.getPosition().getStartOffset();
        int nodeEndPosition = node.getPosition().getEndOffset();
        if (nodeStartPosition < this.fMethodStartPosition) {
            return false;
        }
        return nodeEndPosition <= this.fMethodEndPosition;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.progressMonitorWorked(1);
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.progressMonitorWorked(1);
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.progressMonitorWorked(1);
        return super.visitClassNode(iVisited);
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.progressMonitorWorked(1);
        return super.visitModuleNode(iVisited);
    }

    private void progressMonitorWorked(int work) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(work);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }
}

