/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallLocation;
import org.rubypeople.rdt.internal.corext.callhierarchy.CalleeMethodWrapper;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.rubypeople.rdt.internal.corext.callhierarchy.Implementors;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodCall;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodWrapper;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.util.StringMatcher;

public class CallHierarchy {
    private static final String PREF_USE_IMPLEMENTORS = "PREF_USE_IMPLEMENTORS";
    private static final String PREF_USE_FILTERS = "PREF_USE_FILTERS";
    private static final String PREF_FILTERS_LIST = "PREF_FILTERS_LIST";
    private static final String DEFAULT_IGNORE_FILTERS = "java.*,javax.*";
    private static CallHierarchy fgInstance;
    private IRubySearchScope fSearchScope;
    private StringMatcher[] fFilters;

    public static CallHierarchy getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchy();
        }
        return fgInstance;
    }

    public boolean isSearchUsingImplementorsEnabled() {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_IMPLEMENTORS);
    }

    public void setSearchUsingImplementorsEnabled(boolean enabled) {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_IMPLEMENTORS, enabled);
    }

    public Collection getImplementingMethods(IMethod method) {
        IRubyElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForImplementors(new IRubyElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList(0);
    }

    public Collection getInterfaceMethods(IMethod method) {
        IRubyElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForInterfaces(new IRubyElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList(0);
    }

    public MethodWrapper getCallerRoot(IMethod method) {
        return new CallerMethodWrapper(null, new MethodCall((IMember)method));
    }

    public MethodWrapper getCalleeRoot(IMethod method) {
        return new CalleeMethodWrapper(null, new MethodCall((IMember)method));
    }

    public static CallLocation getCallLocation(Object element) {
        CallLocation callLocation = null;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            MethodCall methodCall = methodWrapper.getMethodCall();
            if (methodCall != null) {
                callLocation = methodCall.getFirstCallLocation();
            }
        } else if (element instanceof CallLocation) {
            callLocation = (CallLocation)element;
        }
        return callLocation;
    }

    public IRubySearchScope getSearchScope() {
        if (this.fSearchScope == null) {
            this.fSearchScope = SearchEngine.createWorkspaceScope();
        }
        return this.fSearchScope;
    }

    public void setSearchScope(IRubySearchScope searchScope) {
        this.fSearchScope = searchScope;
    }

    public boolean isIgnored(String fullyQualifiedName) {
        if (this.getIgnoreFilters() != null && this.getIgnoreFilters().length > 0) {
            int i = 0;
            while (i < this.getIgnoreFilters().length) {
                String fullyQualifiedName1 = fullyQualifiedName;
                if (this.getIgnoreFilters()[i].match(fullyQualifiedName1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isFilterEnabled() {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_FILTERS);
    }

    public void setFilterEnabled(boolean filterEnabled) {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_FILTERS, filterEnabled);
    }

    public String getFilters() {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        return settings.getString(PREF_FILTERS_LIST);
    }

    public void setFilters(String filters) {
        this.fFilters = null;
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_FILTERS_LIST, filters);
    }

    private StringMatcher[] getIgnoreFilters() {
        if (this.fFilters == null) {
            String filterString = null;
            if (this.isFilterEnabled() && (filterString = this.getFilters()) == null) {
                filterString = DEFAULT_IGNORE_FILTERS;
            }
            this.fFilters = filterString != null ? CallHierarchy.parseList(filterString) : null;
        }
        return this.fFilters;
    }

    private static StringMatcher[] parseList(String listString) {
        ArrayList<StringMatcher> list = new ArrayList<StringMatcher>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String textFilter = tokenizer.nextToken().trim();
            list.add(new StringMatcher(textFilter, false, false));
        }
        return list.toArray(new StringMatcher[list.size()]);
    }

    static Node getRubyScriptNode(IMember member, boolean resolveBindings) {
        IRubyScript icu = member.getRubyScript();
        if (icu != null && icu.exists()) {
            return ASTProvider.getASTProvider().getAST((IRubyElement)icu, ASTProvider.WAIT_YES, null);
        }
        return null;
    }
}

