/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;

public class UnexcludeOperation
extends LoadpathModifierOperation {
    public UnexcludeOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip, 3);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List resources = this.getSelectedElements();
            IRubyProject project = this.fInformationProvider.getRubyProject();
            result = this.unExclude(resources, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws RubyModelException {
        if (elements.size() == 0) {
            return false;
        }
        IRubyProject project = this.fInformationProvider.getRubyProject();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            switch (types[i]) {
                case 6: {
                    if (this.isValidFolder((IResource)element, project)) break;
                    return false;
                }
                case 7: {
                    if (this.isValidExcludedFolder((IResource)element, project)) break;
                    return false;
                }
                case 8: {
                    if (this.isValidExcludedFile((IFile)element, project)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isValidFolder(IResource resource, IRubyProject project) throws RubyModelException {
        return LoadpathModifier.isExcluded(resource, project);
    }

    private boolean isValidExcludedFolder(IResource resource, IRubyProject project) throws RubyModelException {
        return LoadpathModifier.isExcluded(resource, project);
    }

    private boolean isValidExcludedFile(IFile file, IRubyProject project) throws RubyModelException {
        return LoadpathModifier.isExcluded((IResource)file, project);
    }

    public String getDescription(int type) {
        IResource resource = (IResource)this.getSelectedElements().get(0);
        String name = UnexcludeOperation.escapeSpecialChars(resource.getName());
        if (type == 6) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFolder, name);
        }
        if (type == 8) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFile, name);
        }
        return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Unexclude, name);
    }
}

