/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;

public class ResetAllOperation
extends LoadpathModifierOperation {
    private ILoadpathEntry[] fEntries;

    public ResetAllOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip, 6);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        this.fException = null;
        try {
            this.fInformationProvider.getRubyProject().setRawLoadpath(this.fEntries, null, monitor);
            this.fInformationProvider.deleteCreatedResources();
            this.fEntries = null;
        }
        catch (CoreException e) {
            this.fException = e;
        }
        super.handleResult(null, monitor);
    }

    public boolean isValid(List elements, int[] types) throws RubyModelException {
        ILoadpathEntry[] currentEntries;
        IRubyProject project = this.fInformationProvider.getRubyProject();
        if (project == null) {
            return false;
        }
        if (this.fEntries == null) {
            this.fEntries = project.getRawLoadpath();
        }
        if ((currentEntries = project.getRawLoadpath()).length != this.fEntries.length) {
            return true;
        }
        int i = 0;
        while (i < this.fEntries.length) {
            if (!this.fEntries[i].equals(currentEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDescription(int type) {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAll;
    }
}

