/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierQueries;

public class LoadpathModifier {
    private ILoadpathModifierListener fListener;

    public LoadpathModifier() {
        this(null);
    }

    protected LoadpathModifier(ILoadpathModifierListener listener) {
        this.fListener = listener;
    }

    public static List removeFilters(IPath path, IRubyProject project, List existingEntries) {
        if (path == null) {
            return Collections.EMPTY_LIST;
        }
        IPath projPath = project.getPath();
        if (projPath.isPrefixOf(path)) {
            path = path.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        ArrayList<CPListElement> result = new ArrayList<CPListElement>();
        for (CPListElement element : existingEntries) {
            IPath[] inclusion;
            boolean hasChange = false;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                ArrayList<IPath> exlusionList = new ArrayList<IPath>(exlusions.length);
                int i = 0;
                while (i < exlusions.length) {
                    if (!exlusions[i].equals((Object)path)) {
                        exlusionList.add(exlusions[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusionList.toArray(new IPath[exlusionList.size()]));
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) != null) {
                ArrayList<IPath> inclusionList = new ArrayList<IPath>(inclusion.length);
                int i = 0;
                while (i < inclusion.length) {
                    if (!inclusion[i].equals((Object)path)) {
                        inclusionList.add(inclusion[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("inclusion", inclusionList.toArray(new IPath[inclusionList.size()]));
            }
            if (!hasChange) continue;
            result.add(element);
        }
        return result;
    }

    public static List getExistingEntries(IRubyProject project) throws RubyModelException {
        ILoadpathEntry[] classpathEntries = project.getRawLoadpath();
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            ILoadpathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting(curr, project));
            ++i;
        }
        return newClassPath;
    }

    public static CPListElement getLoadpathEntry(List elements, ISourceFolderRoot root) throws RubyModelException {
        ILoadpathEntry entry = root.getRawLoadpathEntry();
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = (CPListElement)elements.get(i);
            if (element.getPath().equals((Object)root.getPath()) && element.getEntryKind() == entry.getEntryKind()) {
                return (CPListElement)elements.get(i);
            }
            ++i;
        }
        CPListElement newElement = CPListElement.createFromExisting(entry, root.getRubyProject());
        elements.add(newElement);
        return newElement;
    }

    public static ILoadpathEntry getLoadpathEntryFor(IPath path, IRubyProject project, int entryKind) throws RubyModelException {
        ILoadpathEntry[] entries = project.getRawLoadpath();
        int i = 0;
        while (i < entries.length) {
            ILoadpathEntry entry = entries[i];
            if (entry.getPath().equals((Object)path) && LoadpathModifier.equalEntryKind(entry, entryKind)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private static boolean equalEntryKind(ILoadpathEntry entry, int kind) {
        return entry.getEntryKind() == kind;
    }

    public static boolean filtersSet(ISourceFolderRoot root) throws RubyModelException {
        if (root == null) {
            return false;
        }
        ILoadpathEntry entry = root.getRawLoadpathEntry();
        IPath[] inclusions = entry.getInclusionPatterns();
        IPath[] exclusions = entry.getExclusionPatterns();
        if (inclusions != null && inclusions.length > 0) {
            return true;
        }
        return exclusions != null && exclusions.length > 0;
    }

    public static boolean isExcluded(IResource resource, IRubyProject project) throws RubyModelException {
        ISourceFolderRoot root = LoadpathModifier.getFolderRoot(resource, project, null);
        if (root == null) {
            return false;
        }
        String fragmentName = LoadpathModifier.getName(resource.getFullPath(), root.getPath());
        fragmentName = LoadpathModifier.completeName(fragmentName);
        ILoadpathEntry entry = root.getRawLoadpathEntry();
        return entry != null && LoadpathModifier.contains((IPath)new Path(fragmentName), entry.getExclusionPatterns(), null);
    }

    private static boolean contains(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (path == null) {
            return false;
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ComparePaths, paths.length);
            if (path.getFileExtension() == null) {
                path = new Path(LoadpathModifier.completeName(path.toString()));
            }
            int i = 0;
            while (i < paths.length) {
                if (paths[i].equals((Object)path)) {
                    return true;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private static String completeName(String name) {
        if (!RubyCore.isRubyLikeFileName((String)name)) {
            name = String.valueOf(name) + "/";
            name = name.replace('.', '/');
            return name;
        }
        return name;
    }

    private static String getName(IPath path, IPath rootPath) {
        return path.removeFirstSegments(rootPath.segmentCount()).toString();
    }

    public static ISourceFolderRoot getFolderRoot(IResource resource, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRubyElement javaElem = null;
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return project.getSourceFolderRoot(resource);
        }
        IContainer container = resource.getParent();
        do {
            if (container instanceof IFolder) {
                javaElem = RubyCore.create((IResource)((IFolder)container));
            }
            if (container.getFullPath().equals((Object)project.getPath())) {
                javaElem = project;
                break;
            }
            if ((container = container.getParent()) != null) continue;
            return null;
        } while (javaElem == null || !(javaElem instanceof ISourceFolderRoot));
        if (javaElem instanceof IRubyProject) {
            javaElem = project.getSourceFolderRoot(project.getResource());
        }
        return (ISourceFolderRoot)javaElem;
    }

    protected static String escapeSpecialChars(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isSourceFolder(IRubyProject project) throws RubyModelException {
        return LoadpathModifier.getLoadpathEntryFor(project.getPath(), project, 3) != null;
    }

    protected List addToLoadpath(List elements, IRubyProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.LoadpathModifier_Monitor_AddToBuildpath, 2 * elements.size() + 3);
            RubyPlugin.getWorkspace().getRoot();
            if (project.getProject().hasNature("org.rubypeople.rdt.core.rubynature")) {
                project.getProject().getFullPath();
                List existingEntries = LoadpathModifier.getExistingEntries(project);
                ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
                int i = 0;
                while (i < elements.size()) {
                    Object element = elements.get(i);
                    CPListElement entry = element instanceof IResource ? LoadpathModifier.addToLoadpath((IResource)element, existingEntries, newEntries, project, monitor) : LoadpathModifier.addToLoadpath((IRubyElement)element, existingEntries, newEntries, project, monitor);
                    newEntries.add(entry);
                    ++i;
                }
                HashSet modifiedSourceEntries = new HashSet();
                BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existingEntries.toArray(new CPListElement[existingEntries.size()]), modifiedSourceEntries);
                LoadpathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateLoadpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<IRubyProject> result = new ArrayList<IRubyProject>();
                int i2 = 0;
                while (i2 < newEntries.size()) {
                    ILoadpathEntry entry = ((CPListElement)newEntries.get(i2)).getLoadpathEntry();
                    Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findSourceFolderRoot(entry.getPath());
                    if (root != null) {
                        result.add((IRubyProject)root);
                    }
                    ++i2;
                }
                ArrayList<IRubyProject> arrayList = result;
                return arrayList;
            }
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.LoadpathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        finally {
            monitor.done();
        }
    }

    private void updateLoadpath(List newEntries, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ILoadpathEntry[] entries = LoadpathModifier.convert(newEntries);
            IRubyModelStatus status = RubyConventions.validateLoadpath((IRubyProject)project, (ILoadpathEntry[])entries, null);
            if (!status.isOK()) {
                throw new RubyModelException(status);
            }
            project.setRawLoadpath(entries, null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.fireEvent(newEntries);
        }
        finally {
            monitor.done();
        }
    }

    private static ILoadpathEntry[] convert(List list) {
        ILoadpathEntry[] entries = new ILoadpathEntry[list.size()];
        int i = 0;
        while (i < list.size()) {
            CPListElement element = (CPListElement)list.get(i);
            entries[i] = element.getLoadpathEntry();
            ++i;
        }
        return entries;
    }

    private void fireEvent(List newEntries) {
        if (this.fListener != null) {
            this.fListener.classpathEntryChanged(newEntries);
        }
    }

    public static CPListElement addToLoadpath(IResource resource, List existingEntries, List newEntries, IRubyProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 2);
            LoadpathModifier.exclude(resource.getFullPath(), existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CPListElement cPListElement = entry = new CPListElement(project, 3, resource.getFullPath(), resource);
            return cPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static void exclude(IPath path, List existingEntries, List newEntries, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPath rootPath;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 1);
            CPListElement elem = null;
            CPListElement existingElem = null;
            int i = 0;
            do {
                if ((rootPath = path.removeLastSegments(++i)).segmentCount() == 0) {
                    return;
                }
                elem = LoadpathModifier.getListElement(rootPath, newEntries);
            } while ((existingElem = LoadpathModifier.getListElement(rootPath, existingEntries)) == null && elem == null);
            if (elem == null) {
                elem = existingElem;
            }
            LoadpathModifier.exclude(path.removeFirstSegments(path.segmentCount() - i).toString(), null, elem, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private static CPListElement getListElement(IPath path, List elements) {
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = (CPListElement)elements.get(i);
            if (element.getEntryKind() == 3 && element.getPath().equals((Object)path)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static IPath[] remove(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemovePath, paths.length + 5);
            if (!LoadpathModifier.contains(path, paths, (IProgressMonitor)new SubProgressMonitor(monitor, 5))) {
                IPath[] iPathArray = paths;
                return iPathArray;
            }
            ArrayList<IPath> newPaths = new ArrayList<IPath>();
            int i = 0;
            while (i < paths.length) {
                monitor.worked(1);
                if (!paths[i].equals((Object)path)) {
                    newPaths.add(paths[i]);
                }
                ++i;
            }
            IPath[] iPathArray = newPaths.toArray(new IPath[newPaths.size()]);
            return iPathArray;
        }
        finally {
            monitor.done();
        }
    }

    private static IResource exclude(String name, IPath fullPath, CPListElement entry, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        IResource result;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 6);
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = new IPath[excludedPath.length + 1];
            name = LoadpathModifier.completeName(name);
            Path path = new Path(name);
            if (!LoadpathModifier.contains((IPath)path, excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(excludedPath, 0, newExcludedPath, 0, excludedPath.length);
                newExcludedPath[excludedPath.length] = path;
                entry.setAttribute("exclusion", newExcludedPath);
                entry.setAttribute("inclusion", LoadpathModifier.remove((IPath)path, (IPath[])entry.getAttribute("inclusion"), (IProgressMonitor)new SubProgressMonitor(monitor, 4)));
            }
            result = fullPath == null ? null : LoadpathModifier.getResource(fullPath, project);
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static IResource getResource(IPath path, IRubyProject project) {
        return project.getProject().getWorkspace().getRoot().findMember(path);
    }

    public static CPListElement addToLoadpath(IRubyElement javaElement, List existingEntries, List newEntries, IRubyProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 10);
            CPListElement cPListElement = entry = new CPListElement(project, 3, javaElement.getPath(), javaElement.getResource());
            return cPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static void setNewEntry(List existingEntries, List newEntries, IRubyProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_SetNewEntry, existingEntries.size());
            int i = 0;
            while (i < newEntries.size()) {
                CPListElement entry = (CPListElement)newEntries.get(i);
                LoadpathModifier.validateAndAddEntry(entry, existingEntries, project);
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void validateAndAddEntry(CPListElement entry, List existingEntries, IRubyProject project) throws CoreException {
        IPath path = entry.getPath();
        project.getProject().getFullPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        StatusInfo rootStatus = new StatusInfo();
        rootStatus.setOK();
        boolean isExternal = LoadpathModifier.isExternalArchiveOrLibrary(entry, project);
        if (!isExternal && validate.matches(4) && !project.getPath().equals((Object)path)) {
            rootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            throw new CoreException((IStatus)rootStatus);
        }
        if (!isExternal && !project.getPath().equals((Object)path)) {
            IResource res = workspaceRoot.findMember(path);
            if (res != null) {
                if (res.getType() != 2 && res.getType() != 1) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    throw new CoreException((IStatus)rootStatus);
                }
            } else {
                IFileStore store;
                URI projLocation = project.getProject().getLocationURI();
                if (projLocation != null && (store = EFS.getStore((URI)projLocation).getChild(path)).fetchInfo().exists()) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                    throw new CoreException((IStatus)rootStatus);
                }
            }
        }
        int i = 0;
        while (i < existingEntries.size()) {
            CPListElement curr = (CPListElement)existingEntries.get(i);
            if (curr.getEntryKind() == 3 && path.equals((Object)curr.getPath()) && !project.getPath().equals((Object)path)) {
                rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                throw new CoreException((IStatus)rootStatus);
            }
            ++i;
        }
        if (!isExternal && !entry.getPath().equals((Object)project.getPath())) {
            LoadpathModifier.exclude(entry.getPath(), existingEntries, new ArrayList(), project, null);
        }
        LoadpathModifier.insertAtEndOfCategory(entry, existingEntries);
        ILoadpathEntry[] entries = LoadpathModifier.convert(existingEntries);
        IRubyModelStatus status = RubyConventions.validateLoadpath((IRubyProject)project, (ILoadpathEntry[])entries, null);
        if (!status.isOK()) {
            rootStatus.setError(status.getMessage());
            throw new CoreException((IStatus)rootStatus);
        }
        if (LoadpathModifier.isSourceFolder(project) || project.getPath().equals((Object)path)) {
            rootStatus.setWarning(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
            return;
        }
        rootStatus.setOK();
    }

    private static boolean isExternalArchiveOrLibrary(CPListElement entry, IRubyProject project) {
        if (entry.getEntryKind() == 1 || entry.getEntryKind() == 5) {
            return !(entry.getResource() instanceof IFolder);
        }
        return false;
    }

    private static void insertAtEndOfCategory(CPListElement entry, List existingEntries) {
        int length = existingEntries.size();
        CPListElement[] elements = existingEntries.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getLoadpathEntry().getEntryKind() != entry.getLoadpathEntry().getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getLoadpathEntry().getEntryKind() == entry.getLoadpathEntry().getEntryKind()) {
                ++i;
            }
            existingEntries.add(i, entry);
            return;
        }
        switch (entry.getLoadpathEntry().getEntryKind()) {
            case 3: {
                existingEntries.add(0, entry);
                break;
            }
            default: {
                existingEntries.add(entry);
            }
        }
    }

    protected List removeFromLoadpath(LoadpathModifierQueries.IRemoveLinkedFolderQuery query, List elements, IRubyProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, elements.size() + 1);
            List existingEntries = LoadpathModifier.getExistingEntries(project);
            ArrayList<IRubyProject> resultElements = new ArrayList<IRubyProject>();
            boolean archiveRemoved = false;
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                IRubyProject res = null;
                if (element instanceof IRubyProject) {
                    res = LoadpathModifier.removeFromLoadpath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else if (element instanceof ISourceFolderRoot) {
                    ISourceFolderRoot root = (ISourceFolderRoot)element;
                    IResource resource = root.getCorrespondingResource();
                    if (resource instanceof IFolder) {
                        IFolder folder = (IFolder)resource;
                        if (folder.isLinked()) {
                            int result = query.doQuery(folder);
                            if (result != 0) {
                                if (result == 1) {
                                    res = LoadpathModifier.removeFromLoadpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                } else if (result == 2) {
                                    res = LoadpathModifier.removeFromLoadpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                            }
                        } else {
                            res = LoadpathModifier.removeFromLoadpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    } else {
                        res = LoadpathModifier.removeFromLoadpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                } else {
                    archiveRemoved = true;
                    LoadPathContainer container = (LoadPathContainer)element;
                    existingEntries.remove(CPListElement.createFromExisting(container.getLoadpathEntry(), project));
                }
                if (res != null) {
                    resultElements.add(res);
                }
                ++i;
            }
            this.updateLoadpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fireEvent(existingEntries);
            if (archiveRemoved && resultElements.size() == 0) {
                resultElements.add(project);
            }
            ArrayList<IRubyProject> arrayList = resultElements;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public static IRubyProject removeFromLoadpath(IRubyProject project, List existingEntries, IProgressMonitor monitor) throws CoreException {
        CPListElement elem = LoadpathModifier.getListElement(project.getPath(), existingEntries);
        if (elem != null) {
            existingEntries.remove(elem);
        }
        return project;
    }

    public static IResource removeFromLoadpath(ISourceFolderRoot root, List existingEntries, IRubyProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, 1);
            ILoadpathEntry entry = root.getRawLoadpathEntry();
            CPListElement elem = CPListElement.createFromExisting(entry, project);
            existingEntries.remove(elem);
            LoadpathModifier.removeFilters(elem.getPath(), project, existingEntries);
            IResource iResource = elem.getResource();
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    protected List exclude(List javaElements, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, javaElements.size() + 4);
            List existingEntries = LoadpathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < javaElements.size()) {
                ISourceFolderRoot root;
                CPListElement entry;
                IRubyElement javaElement = (IRubyElement)javaElements.get(i);
                IResource resource = LoadpathModifier.exclude(javaElement, entry = LoadpathModifier.getLoadpathEntry(existingEntries, root = (ISourceFolderRoot)javaElement.getAncestor(2)), project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (resource != null) {
                    resources.add(resource);
                }
                ++i;
            }
            this.updateLoadpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            ArrayList<IResource> arrayList = resources;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public static IResource exclude(IRubyElement javaElement, CPListElement entry, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String name = LoadpathModifier.getName(javaElement.getPath(), entry.getPath());
            IResource iResource = LoadpathModifier.exclude(name, javaElement.getPath(), entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    protected List unExclude(List elements, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List resultElements;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Including, 2 * elements.size());
            List entries = LoadpathModifier.getExistingEntries(project);
            int i = 0;
            while (i < elements.size()) {
                IResource resource = (IResource)elements.get(i);
                ISourceFolderRoot root = LoadpathModifier.getFolderRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (root != null) {
                    CPListElement entry = LoadpathModifier.getLoadpathEntry(entries, root);
                    LoadpathModifier.unExclude(resource, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
            this.updateLoadpath(entries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = resultElements = LoadpathModifier.getCorrespondingElements(elements, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    public static void unExclude(IResource resource, CPListElement entry, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveExclusion, 10);
            String name = LoadpathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = LoadpathModifier.remove((IPath)new Path(LoadpathModifier.completeName(name)), excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            entry.setAttribute("exclusion", newExcludedPath);
        }
        finally {
            monitor.done();
        }
    }

    public static List getCorrespondingElements(List entries, IRubyProject project) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < entries.size()) {
            Object element = entries.get(i);
            IPath path = element instanceof IResource ? ((IResource)element).getFullPath() : ((IRubyElement)element).getPath();
            IResource resource = LoadpathModifier.getResource(path, project);
            if (resource != null) {
                IRubyElement elem = RubyCore.create((IResource)resource);
                if (elem != null && project.isOnLoadpath(elem)) {
                    result.add(elem);
                } else {
                    result.add(resource);
                }
            }
            ++i;
        }
        return result;
    }

    public static void commitLoadPath(List newEntries, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ILoadpathEntry[] entries = LoadpathModifier.convert(newEntries);
            IRubyModelStatus status = RubyConventions.validateLoadpath((IRubyProject)project, (ILoadpathEntry[])entries, null);
            if (!status.isOK()) {
                throw new RubyModelException(status);
            }
            project.setRawLoadpath(entries, null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static ISourceFolder getFolder(IResource resource) {
        IRubyElement elem = RubyCore.create((IResource)resource);
        if (elem instanceof ISourceFolder) {
            return (ISourceFolder)elem;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parentExcluded(IResource resource, IRubyProject project) throws RubyModelException {
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return false;
        }
        root = LoadpathModifier.getFolderRoot(resource, project, null);
        if (root == null) {
            return true;
        }
        path = resource.getFullPath().removeFirstSegments(root.getPath().segmentCount());
        entry = root.getRawLoadpathEntry();
        if (entry != null) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (LoadpathModifier.contains(path, entry.getExclusionPatterns(), null)) {
                return true;
            }
            path = path.removeLastSegments(1);
lbl13:
            // 2 sources

            ** while (path.segmentCount() > 0)
        }
lbl14:
        // 1 sources

        return false;
    }

    public static boolean isIncluded(IRubyElement selection, IRubyProject project, IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ContainsPath, 4);
            ISourceFolderRoot root = (ISourceFolderRoot)selection.getAncestor(2);
            ILoadpathEntry entry = root.getRawLoadpathEntry();
            if (entry == null) {
                return false;
            }
            boolean bl = LoadpathModifier.contains(selection.getPath().removeFirstSegments(root.getPath().segmentCount()), entry.getInclusionPatterns(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isDefaultFolder(ISourceFolder fragment) {
        return fragment.getElementName().length() == 0;
    }

    public static interface ILoadpathModifierListener {
        public void classpathEntryChanged(List var1);
    }
}

