/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;

public class ExcludeOperation
extends LoadpathModifierOperation {
    public ExcludeOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip, 2);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List javaElements = this.getSelectedElements();
            IRubyProject project = this.fInformationProvider.getRubyProject();
            result = this.exclude(javaElements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws RubyModelException {
        if (elements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            int type = types[i];
            if (type != 3 && type != 11 && !(element instanceof IRubyScript)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getDescription(int type) {
        IRubyElement elem = (IRubyElement)this.getSelectedElements().get(0);
        String name = ExcludeOperation.escapeSpecialChars(elem.getElementName());
        if (type == 3) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, name);
        }
        if (type == 11) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, name);
        }
        if (type == 4) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, name);
        }
        if (type == 10) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, name);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Exclude;
    }
}

