/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;

public class EditFiltersOperation
extends LoadpathModifierOperation {
    private final ILoadpathInformationProvider fCPInformationProvider;
    private final LoadpathModifier.ILoadpathModifierListener fListener;

    public EditFiltersOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip, 4);
        this.fListener = listener;
        this.fCPInformationProvider = informationProvider;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        GenerateBuildPathActionGroup.EditFilterAction action = new GenerateBuildPathActionGroup.EditFilterAction();
        IStructuredSelection selection = this.fCPInformationProvider.getSelection();
        Object firstElement = selection.getFirstElement();
        action.selectionChanged(selection);
        action.run();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(firstElement);
        if (this.fListener != null) {
            List entries = action.getCPListElements();
            this.fListener.classpathEntryChanged(entries);
        }
        this.fCPInformationProvider.handleResult(l, null, 4);
    }

    public boolean isValid(List elements, int[] types) throws RubyModelException {
        if (elements.size() != 1) {
            return false;
        }
        IRubyProject project = this.fInformationProvider.getRubyProject();
        Object element = elements.get(0);
        return element instanceof IRubyProject ? EditFiltersOperation.isSourceFolder(project) : element instanceof ISourceFolderRoot;
    }

    public String getDescription(int type) {
        if (type == 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        if (type == 2) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        if (type == 14) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Edit;
    }
}

