/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.model.IVariable;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.debug.core.model.IRubyVariable;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;

public class VariableReader
extends XmlStreamReader {
    private IRubyStackFrame stackFrame;
    private IRubyVariable parent;
    private List<IVariable> variables;
    private String exceptionMessage;
    private String exceptionType;

    public VariableReader(XmlPullParser xpp) {
        super(xpp);
    }

    public VariableReader(AbstractReadStrategy readStrategy) {
        super(readStrategy);
    }

    public RubyVariable[] readVariables(IRubyVariable variable) throws RubyProcessingException {
        return this.readVariables(variable.getStackFrame(), variable);
    }

    public RubyVariable[] readVariables(IRubyStackFrame stackFrame) throws RubyProcessingException {
        return this.readVariables(stackFrame, null);
    }

    public RubyVariable[] readVariables(IRubyStackFrame stackFrame, IRubyVariable parent) throws RubyProcessingException {
        this.stackFrame = stackFrame;
        this.parent = parent;
        this.variables = new ArrayList<IVariable>();
        try {
            this.read();
        }
        catch (Exception ex) {
            RdtDebugCorePlugin.log(ex);
            return new RubyVariable[0];
        }
        if (this.exceptionMessage != null) {
            throw new RubyProcessingException(this.exceptionType, this.exceptionMessage);
        }
        if (this.isWaitTimeExpired()) {
            throw new RubyProcessingException("Timeout: Could not read result.");
        }
        RubyVariable[] variablesArray = new RubyVariable[this.variables.size()];
        this.variables.toArray(variablesArray);
        return variablesArray;
    }

    protected boolean processStartElement(XmlPullParser xpp) {
        String name = xpp.getName();
        if (name.equals("variables")) {
            return true;
        }
        if (name.equals("variable")) {
            RubyVariable newVariable;
            String varName = xpp.getAttributeValue("", "name");
            String varValue = xpp.getAttributeValue("", "value");
            String kind = xpp.getAttributeValue("", "kind");
            if (varValue == null) {
                newVariable = new RubyVariable(this.stackFrame, varName, kind);
            } else {
                String typeName = xpp.getAttributeValue("", "type");
                boolean hasChildren = xpp.getAttributeValue("", "hasChildren").equals("true");
                String objectId = xpp.getAttributeValue("", "objectId");
                newVariable = new RubyVariable(this.stackFrame, varName, kind, varValue, typeName, hasChildren, objectId);
            }
            newVariable.setParent(this.parent);
            this.variables.add(newVariable);
            return true;
        }
        if (name.equals("processingException")) {
            this.exceptionMessage = xpp.getAttributeValue("", "message");
            this.exceptionType = xpp.getAttributeValue("", "type");
            return true;
        }
        return false;
    }

    protected boolean processEndElement(XmlPullParser xpp) {
        return !xpp.getName().equals("variable");
    }
}

