/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.debug.core;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.RubyCore;

public class RdtDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.rubypeople.rdt.debug.core";
    public static final String MODEL_IDENTIFIER = "org.rubypeople.rdt.debug";
    public static final int INTERNAL_ERROR = 120;
    private static boolean isRubyDebuggerVerbose = false;
    protected static RdtDebugCorePlugin plugin;

    public RdtDebugCorePlugin() {
        plugin = this;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        String rubyDebuggerVerboseOption = Platform.getDebugOption((String)"org.rubypeople.rdt.debug.core/rubyDebuggerVerbose");
        isRubyDebuggerVerbose = rubyDebuggerVerboseOption == null ? false : rubyDebuggerVerboseOption.equalsIgnoreCase("true");
    }

    public static void log(int severity, String message) {
        Status status = new Status(severity, PLUGIN_ID, 0, message, null);
        RdtDebugCorePlugin.log((IStatus)status);
    }

    public static void log(String message, Throwable e) {
        RdtDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, e));
    }

    public static void log(IStatus status) {
        if (RdtDebugCorePlugin.getDefault() != null) {
            RdtDebugCorePlugin.getDefault().getLog().log(status);
        } else {
            System.out.println("Error: ");
            System.out.println(status.getMessage());
        }
    }

    public static void log(Throwable e) {
        RdtDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "RdtLaunchingPlugin.internalErrorOccurred", e));
    }

    public static void debug(Object message) {
        if (RdtDebugCorePlugin.getDefault() != null) {
            if (RdtDebugCorePlugin.getDefault().isDebugging()) {
                System.out.println(message.toString());
            }
        } else {
            System.out.println(message.toString());
        }
    }

    public static void debug(String message, Throwable e) {
        if (RdtDebugCorePlugin.getDefault() != null) {
            if (RdtDebugCorePlugin.getDefault().isDebugging()) {
                System.out.println(String.valueOf(message) + ", Exception: " + e.getMessage());
                RdtDebugCorePlugin.log(e);
            }
        } else {
            System.out.println(message);
            e.printStackTrace();
        }
    }

    public static boolean isRubyDebuggerVerbose() {
        return isRubyDebuggerVerbose;
    }

    public static String getPluginIdentifier() {
        return PLUGIN_ID;
    }
}

