/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.RubyRuntime;

public abstract class AbstractRubyLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        return args;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            File dir = this.getDefaultWorkingDirectory(configuration);
            if (dir != null) {
                if (!dir.isDirectory()) {
                    this.abort(MessageFormat.format(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, dir.toString()), null, 108);
                }
                return dir;
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, path.toString()), null, 108);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, path.toString()), null, 108);
        }
        return null;
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        if (path != null && path.length() > 0) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }

    protected File getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IRubyProject rp = this.getRubyProject(configuration);
        if (rp != null) {
            IProject p = rp.getProject();
            return p.getLocation().toFile();
        }
        return null;
    }

    public IRubyProject getRubyProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IRubyProject rubyProject;
        String projectName = this.getRubyProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (rubyProject = RubyCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && rubyProject.exists()) {
            return rubyProject;
        }
        return null;
    }

    public String getRubyProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    public Map getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
        return map;
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_0, vm.getName(), mode), null, 106);
        }
        return runner;
    }

    public IVMInstall verifyVMInstall(ILaunchConfiguration configuration) throws CoreException {
        File location;
        IVMInstall vm = this.getVMInstall(configuration);
        if (vm == null) {
            this.abort(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_The_specified_JRE_installation_does_not_exist_4, null, 105);
        }
        if ((location = vm.getInstallLocation()) == null) {
            this.abort(MessageFormat.format(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_JRE_home_directory_not_specified_for__0__5, vm.getName()), null, 105);
        }
        if (!location.exists()) {
            this.abort(MessageFormat.format(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_JRE_home_directory_for__0__does_not_exist___1__6, vm.getName(), location.getAbsolutePath()), null, 105);
        }
        return vm;
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        return RubyRuntime.computeVMInstall(configuration);
    }

    public String verifyFileToLaunch(ILaunchConfiguration configuration) throws CoreException {
        IPath fileToLaunch;
        IPath fileToLaunch2;
        File file;
        String name = this.getFileToLaunch(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Main_type_not_specified_11, null, 101);
        }
        if ((file = new File(name)).exists() && !file.isDirectory()) {
            return name;
        }
        IPath workingDir = this.getWorkingDirectoryPath(configuration);
        if (workingDir != null && (file = (fileToLaunch2 = workingDir.append(name)).toFile()).exists() && !file.isDirectory()) {
            return name;
        }
        IRubyProject project = this.getRubyProject(configuration);
        if (project != null && (file = (fileToLaunch = project.getProject().getLocation().append(name)).toFile()).exists() && !file.isDirectory()) {
            return fileToLaunch.toOSString();
        }
        this.abort("File to launch does not exist: '" + name + "'", null, 101);
        return null;
    }

    public String getFileToLaunch(ILaunchConfiguration configuration) throws CoreException {
        String mainType = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, null);
        if (mainType == null) {
            return null;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(mainType);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) {
    }

    public String[] getLoadpath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeLoadpathEntry[] entries = RubyRuntime.computeUnresolvedRuntimeLoadpath(configuration);
        entries = RubyRuntime.resolveRuntimeLoadpath(entries, configuration);
        ArrayList<String> userEntries = new ArrayList<String>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getLoadpathProperty() == 3 && (location = entries[i].getLocation()) != null) {
                userEntries.add(location);
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }

    public boolean getIsSudo(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_IS_SUDO, false);
    }

    public String getSudoMessage(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_SUDO_MESSAGE, null);
    }

    public String getVMConnectorId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_CONNECTOR, null);
    }
}

