/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.LibraryInfo;
import org.rubypeople.rdt.internal.launching.StandardVM;
import org.rubypeople.rdt.launching.AbstractVMInstallType;
import org.rubypeople.rdt.launching.IVMInstall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardVMType
extends AbstractVMInstallType {
    private static final String DEFAULT_MAJOR_MINOR_VERSION = "1.8";
    private static final String DEFAULT_VERSION = "1.8.6";
    private static final String USR = "/usr";
    private static final String USR_BIN_RUBY = "/usr/bin/ruby";
    private static final String USR_LOCAL_BIN_RUBY = "/usr/local/bin/ruby";
    private static final String OPT_LOCAL_BIN_RUBY = "/opt/local/bin/ruby";
    private static final String MAC_OSX_LEOPARD_RUBY_PATH = "/System/Library/Frameworks/Ruby.framework/Versions/Current/usr/bin/ruby";
    private static Map<String, LibraryInfo> fgFailedInstallPath = new HashMap<String, LibraryInfo>();
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateRubyFiles = new String[]{"rubyw", "rubyw.exe", "ruby", "ruby.exe", "ruby1.8", "ruby1.9"};
    private static final String[] fgCandidateRubyLocations = new String[]{"", "bin" + fgSeparator};

    @Override
    protected IVMInstall doCreateVMInstall(String id) {
        return new StandardVM(this, id);
    }

    @Override
    public IPath[] getDefaultLibraryLocations(File installLocation) {
        LibraryInfo info;
        File rubyExecutable = StandardVMType.findRubyExecutable(installLocation);
        if (rubyExecutable == null) {
            LaunchingPlugin.logInfo("Unable to find ruby executable under: " + installLocation);
            info = this.getDefaultLibraryInfo(installLocation);
        } else {
            info = this.getLibraryInfo(installLocation, rubyExecutable);
        }
        String[] loadpath = info.getBootpath();
        IPath[] paths = new IPath[loadpath.length];
        int i = 0;
        while (i < loadpath.length) {
            paths[i] = new Path(loadpath[i]);
            ++i;
        }
        return paths;
    }

    @Override
    public String getName() {
        return LaunchingMessages.StandardVMType_Standard_VM_3;
    }

    @Override
    public IStatus validateInstallLocation(File rubyHome) {
        Status status = null;
        File rubyExecutable = StandardVMType.findRubyExecutable(rubyHome);
        status = rubyExecutable == null ? new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_Root__Java_executable_was_not_found_1, null) : (this.canDetectDefaultSystemLibraries(rubyHome, rubyExecutable) ? new Status(0, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_ok_2, null) : new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_root__System_library_was_not_found__1, null));
        return status;
    }

    public static File findRubyExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateRubyFiles.length) {
            int j = 0;
            while (j < fgCandidateRubyLocations.length) {
                File rubyFile = new File(vmInstallLocation, String.valueOf(fgCandidateRubyLocations[j]) + fgCandidateRubyFiles[i]);
                if (rubyFile.isFile()) {
                    return rubyFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected boolean canDetectDefaultSystemLibraries(File rubyHome, File rubyExecutable) {
        File foundExecutable = StandardVMType.findRubyExecutable(rubyHome);
        if (foundExecutable == null || !foundExecutable.exists()) {
            return false;
        }
        IPath[] locations = this.getDefaultLibraryLocations(rubyHome);
        return locations != null && locations.length > 0;
    }

    @Override
    protected synchronized LibraryInfo getLibraryInfo(File rubyHome, File rubyExecutable) {
        String installPath = rubyHome.getAbsolutePath();
        LibraryInfo info = LaunchingPlugin.getLibraryInfo(this, installPath);
        if (info == null && (info = fgFailedInstallPath.get(installPath)) == null) {
            info = this.generateLibraryInfo(rubyHome, rubyExecutable);
            if (info == null) {
                info = this.getDefaultLibraryInfo(rubyHome);
                fgFailedInstallPath.put(installPath, info);
            } else {
                LaunchingPlugin.setLibraryInfo(this, installPath, info);
            }
        }
        return info;
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath[] dflts = this.getDefaultSystemLibrary(installLocation);
        String[] strings = new String[dflts.length];
        int i = 0;
        while (i < dflts.length) {
            strings[i] = dflts[i].toOSString();
            ++i;
        }
        return new LibraryInfo(DEFAULT_VERSION, strings);
    }

    protected IPath[] getDefaultSystemLibrary(File rubyHome) {
        String stdPath = String.valueOf(rubyHome.getAbsolutePath()) + fgSeparator + "lib" + fgSeparator + "ruby" + fgSeparator + DEFAULT_MAJOR_MINOR_VERSION;
        String sitePath = String.valueOf(rubyHome.getAbsolutePath()) + fgSeparator + "lib" + fgSeparator + "ruby" + fgSeparator + "site_ruby" + fgSeparator + DEFAULT_MAJOR_MINOR_VERSION;
        IPath[] paths = new IPath[]{new Path(sitePath), new Path(stdPath)};
        return paths;
    }

    @Override
    public File detectInstallLocation() {
        File rubyHome;
        if (Platform.getOS().equals("win32")) {
            return this.tryLocation(this.detectInstallOnWindows());
        }
        File rubyExecutable = null;
        if (Platform.getOS().equals("macosx") && (rubyHome = this.tryLocation(new File(MAC_OSX_LEOPARD_RUBY_PATH))) != null) {
            return rubyHome;
        }
        File tentativeRubyHome = null;
        try {
            rubyExecutable = this.parseRubyExecutableLocation(this.executeAndRead(new String[]{"which", "ruby"}));
            tentativeRubyHome = this.tryLocation(rubyExecutable);
        }
        catch (Exception e) {
            LaunchingPlugin.log(e);
        }
        if (tentativeRubyHome == null || tentativeRubyHome.getAbsolutePath().equals(USR)) {
            File rubyHome2 = this.tryLocation(new File(USR_LOCAL_BIN_RUBY));
            if (rubyHome2 != null) {
                return rubyHome2;
            }
            rubyHome2 = this.tryLocation(new File(OPT_LOCAL_BIN_RUBY));
            if (rubyHome2 != null) {
                return rubyHome2;
            }
        }
        if (tentativeRubyHome != null) {
            return tentativeRubyHome;
        }
        return this.tryLocation(new File(USR_BIN_RUBY));
    }

    private File detectInstallOnWindows() {
        String winPath = System.getenv("Path");
        String[] paths = winPath.split(";");
        int i = 0;
        while (i < paths.length) {
            String possibleExecutablePath = String.valueOf(paths[i]) + File.separator + "ruby.exe";
            File possible = new File(possibleExecutablePath);
            if (possible.exists()) {
                return possible;
            }
            ++i;
        }
        return new File("C:" + File.separator + "ruby" + File.separator + "bin" + File.separator + "ruby.exe");
    }

    private File tryLocation(File rubyExecutable) {
        if (rubyExecutable == null) {
            return null;
        }
        File bin = rubyExecutable.getParentFile();
        if (!bin.exists()) {
            return null;
        }
        File rubyHome = bin.getParentFile();
        if (!rubyHome.exists()) {
            return null;
        }
        if (!this.canDetectDefaultSystemLibraries(rubyHome, rubyExecutable)) {
            LaunchingPlugin.logInfo("Was unable to detect default ruby system libraries at: " + rubyHome.getAbsolutePath());
            return null;
        }
        return rubyHome;
    }

    @Override
    public File findExecutable(File installLocation) {
        return StandardVMType.findRubyExecutable(installLocation);
    }

    @Override
    public String getVMPlatform(File rubyHome, File rubyExecutable) {
        String rubyExecutablePath = rubyExecutable.getAbsolutePath();
        String[] cmdLine = new String[]{rubyExecutablePath, "-v"};
        String platform = this.parsePlatform(this.executeAndRead(cmdLine));
        if (platform == null) {
            LaunchingPlugin.log(MessageFormat.format("Failed to retrieve platform for {0}", rubyHome.getAbsolutePath()));
        }
        return platform;
    }

    private String parsePlatform(List<String> lines) {
        if (lines == null || lines.size() == 0) {
            return null;
        }
        String firstLine = lines.remove(0);
        Pattern pat = Pattern.compile("ruby\\s\\d\\.\\d\\.\\d\\s\\(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d\\spatchlevel\\s\\d+\\)\\s\\[.+\\-(.+)\\]");
        Matcher m = pat.matcher(firstLine);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

