/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.osgi.framework.Version;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.Sudo;
import org.rubypeople.rdt.launching.AbstractVMRunner;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardVMRunner
extends AbstractVMRunner {
    private static final String SUDO_PROMPT = "Password:";
    public static final String STREAM_FLUSH_SCRIPT = "rdt_stream_sync.rb";
    private static final String LOADPATH_SWITCH = "-I";
    protected static final String END_OF_OPTIONS_DELIMITER = "--";
    protected boolean isVMArgs = true;

    protected String renderDebugTarget(String classToRun, int host) {
        String format = LaunchingMessages.StandardVMRunner__0__at_localhost__1__1;
        return MessageFormat.format(format, classToRun, String.valueOf(host));
    }

    public static String renderProcessLabel(String[] commandLine) {
        String format = LaunchingMessages.StandardVMRunner__0____1___2;
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine[0], timestamp);
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            if (commandLine[i] != null) {
                buf.append(' ');
                char[] characters = commandLine[i].toCharArray();
                StringBuffer command = new StringBuffer();
                boolean containsSpace = false;
                int j = 0;
                while (j < characters.length) {
                    char character = characters[j];
                    if (character == '\"') {
                        command.append('\\');
                    } else if (character == ' ') {
                        containsSpace = true;
                    }
                    command.append(character);
                    ++j;
                }
                if (containsSpace) {
                    buf.append('\"');
                    buf.append(command.toString());
                    buf.append('\"');
                } else {
                    buf.append(command.toString());
                }
            }
            ++i;
        }
        return buf.toString();
    }

    protected void addArguments(String[] args, List<String> v) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            v.add(args[i]);
            ++i;
        }
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort(MessageFormat.format(LaunchingMessages.StandardVMRunner_Specified_working_directory_does_not_exist_or_is_not_a_directory___0__3, path), null, 108);
        }
        return dir;
    }

    @Override
    protected String getPluginIdentifier() {
        return LaunchingPlugin.getUniqueIdentifier();
    }

    protected List<String> constructProgramString(VMRunnerConfiguration config) throws CoreException {
        String command;
        ArrayList<String> string = new ArrayList<String>();
        if (!Platform.getOS().equals("win32") && config.isSudo()) {
            this.forceBackgroundSudoCommand(config);
            string.add("sudo");
        }
        if ((command = this.getCommand(config)) == null) {
            File exe = this.fVMInstance.getVMInstallType().findExecutable(this.fVMInstance.getInstallLocation());
            if (exe == null) {
                this.abort(MessageFormat.format(LaunchingMessages.StandardVMRunner_Unable_to_locate_executable_for__0__1, this.fVMInstance.getName()), null, 150);
            }
            string.add(exe.getAbsolutePath());
            return string;
        }
        String installLocation = String.valueOf(this.fVMInstance.getInstallLocation().getAbsolutePath()) + File.separatorChar;
        File originalExe = new File(String.valueOf(installLocation) + "bin" + File.separatorChar + command);
        File exe = originalExe;
        if (this.fileExists(exe)) {
            string.add(exe.getAbsolutePath());
            return string;
        }
        if (this.fileExists(exe = new File(String.valueOf(exe.getAbsolutePath()) + ".exe"))) {
            string.add(exe.getAbsolutePath());
            return string;
        }
        String version = this.fVMInstance.getRubyVersion();
        Version versionObj = new Version(version);
        exe = new File(String.valueOf(originalExe.getAbsolutePath()) + versionObj.getMajor() + "." + versionObj.getMinor());
        if (this.fileExists(exe)) {
            string.add(exe.getAbsolutePath());
            return string;
        }
        if (this.fileExists(exe = new File(String.valueOf(exe.getAbsolutePath()) + ".exe"))) {
            string.add(exe.getAbsolutePath());
            return string;
        }
        this.abort(MessageFormat.format(LaunchingMessages.StandardVMRunner_Specified_executable__0__does_not_exist_for__1__4, command, this.fVMInstance.getName()), null, 150);
        return null;
    }

    protected void forceBackgroundSudoCommand(VMRunnerConfiguration config) throws CoreException {
        final Process p = this.exec(new String[]{"sudo", "-S", "-p", SUDO_PROMPT, "echo", "forced"}, null);
        final InputStream errorStream = p.getErrorStream();
        final String sudoMsg = config.getSudoMessage();
        Job job = new Job("Read error stream"){

            protected IStatus run(IProgressMonitor monitor) {
                StringBuffer buffer = new StringBuffer();
                String lineDelimeter = "\n";
                block2: while (true) {
                    try {
                        int value;
                        while ((value = errorStream.read()) != -1) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            buffer.append((char)value);
                            if (!buffer.toString().contains(StandardVMRunner.SUDO_PROMPT)) continue;
                            buffer.delete(0, buffer.length());
                            String pw = Sudo.getPassword(sudoMsg);
                            p.getOutputStream().write((String.valueOf(pw) + lineDelimeter).getBytes());
                            p.getOutputStream().flush();
                            break block2;
                        }
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                        continue;
                    }
                    break;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            LaunchingPlugin.log(e);
        }
        if (p.exitValue() != 0) {
            job.cancel();
            this.forceBackgroundSudoCommand(config);
        }
    }

    protected String getCommand(VMRunnerConfiguration config) {
        String command = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND);
        }
        return command;
    }

    protected boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    protected List<String> convertLoadPath(VMRunnerConfiguration config, String[] lp) {
        String working = null;
        try {
            File workingDir = this.getWorkingDir(config);
            if (workingDir != null) {
                working = workingDir.getAbsolutePath();
            }
        }
        catch (CoreException coreException) {}
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i < lp.length) {
            String path = lp[i];
            if (working == null || !working.equals(path)) {
                strings.add(LOADPATH_SWITCH);
                strings.add(path);
            }
            ++i;
        }
        return strings;
    }

    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.StandardVMRunner_Launching_VM____1, 2);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Constructing_command_line____2);
        List<String> arguments = this.constructProgramString(config);
        String[] allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        String[] lp = config.getLoadPath();
        if (lp.length > 0) {
            arguments.addAll(this.convertLoadPath(config, lp));
        }
        this.addStreamSync(arguments);
        arguments.add(END_OF_OPTIONS_DELIMITER);
        arguments.add(this.getFileToLaunch(config));
        this.addArguments(config.getProgramArguments(), arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        String[] envp = this.getEnvironment(config);
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Starting_virtual_machine____3);
        Process p = null;
        File workingDir = this.getWorkingDir(config);
        p = envp != null && envp.length > 0 ? this.exec(cmdLine, workingDir, envp) : this.exec(cmdLine, workingDir);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = this.newProcess(launch, p, StandardVMRunner.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, StandardVMRunner.renderCommandLine(cmdLine));
        process.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME));
        process.setAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH, launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH));
        subMonitor.worked(1);
        subMonitor.done();
    }

    protected String getFileToLaunch(VMRunnerConfiguration config) {
        String file = config.getFileToLaunch();
        if (this.fVMInstance.getPlatform().equals("cygwin")) {
            file = file.replace('\\', '/');
        }
        return file;
    }

    protected String[] getEnvironment(VMRunnerConfiguration config) {
        String[] envp = config.getEnvironment();
        if (Platform.getOS().equals("win32")) {
            if (!this.fVMInstance.getPlatform().equals("cygwin")) {
                return envp;
            }
            return new String[]{"PATH=/usr/local/bin:/usr/bin:/bin"};
        }
        ArrayList<String> newEnv = new ArrayList<String>();
        Map<String, String> environment = System.getenv();
        for (String key : environment.keySet()) {
            String value = environment.get(key);
            if (key.equalsIgnoreCase("PATH")) {
                File exe = this.fVMInstance.getVMInstallType().findExecutable(this.fVMInstance.getInstallLocation());
                value = String.valueOf(exe.getParent()) + ":/opt/local/bin:/usr/local/bin:" + value;
            }
            newEnv.add(String.valueOf(key) + "=" + value);
        }
        int length = envp == null ? 0 : envp.length;
        int i = 0;
        while (i < length) {
            newEnv.add(envp[i]);
            ++i;
        }
        return newEnv.toArray(new String[newEnv.size()]);
    }

    protected void addStreamSync(List<String> arguments) {
        File sync = LaunchingPlugin.getFileInPlugin(new Path("ruby").append("flush").append(STREAM_FLUSH_SCRIPT));
        arguments.add(LOADPATH_SWITCH);
        arguments.add(sync.getParent());
        arguments.add("-rrdt_stream_sync.rb");
    }
}

