/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.SocketUtil;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.StandardVMRunner;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardVMDebugger
extends StandardVMRunner
implements IVMRunner {
    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.StandardVMDebugger_Launching_VM____1, 4);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Finding_free_socket____2);
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(LaunchingMessages.StandardVMDebugger_Could_not_find_a_free_socket_for_the_debugger_1, null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Constructing_command_line____3);
        RubyDebugTarget debugTarget = new RubyDebugTarget(launch, port);
        List<String> arguments = this.constructProgramString(config);
        String[] allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        String[] cp = config.getLoadPath();
        if (cp.length > 0) {
            arguments.addAll(this.convertLoadPath(config, cp));
        }
        this.addStreamSync(arguments);
        arguments.addAll(this.debugSpecificVMArgs(debugTarget));
        arguments.add("--");
        arguments.addAll(this.debugArgs(debugTarget));
        arguments.add(this.getFileToLaunch(config));
        this.addArguments(config.getProgramArguments(), arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        String[] envp = this.getEnvironment(config);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Starting_virtual_machine____4);
        Process p = null;
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.getWorkingDir(config);
        p = this.exec(cmdLine, workingDir, envp);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = this.newProcess(launch, p, StandardVMDebugger.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
        String commandLine = StandardVMDebugger.renderCommandLine(cmdLine);
        LaunchingPlugin.debug("Starting: " + commandLine);
        process.setAttribute(IProcess.ATTR_CMDLINE, commandLine);
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Establishing_debug_connection____5);
        debugTarget.setProcess(process);
        RubyDebuggerProxy proxy = this.getDebugProxy(debugTarget);
        try {
            proxy.start();
            launch.addDebugTarget((IDebugTarget)debugTarget);
        }
        catch (IOException iOException) {
            LaunchingPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.launching", 4, LaunchingMessages.RdtLaunchingPlugin_processTerminatedBecauseNoDebuggerConnection, null));
            debugTarget.terminate();
        }
        catch (RubyProcessingException e) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_connect_to_VM_5, e, 120);
            debugTarget.terminate();
        }
    }

    protected Collection<String> debugArgs(RubyDebugTarget debugTarget) throws CoreException {
        return new ArrayList<String>();
    }

    protected RubyDebuggerProxy getDebugProxy(RubyDebugTarget debugTarget) {
        return new RubyDebuggerProxy((IRubyDebugTarget)debugTarget, false);
    }

    protected List<String> debugSpecificVMArgs(RubyDebugTarget debugTarget) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-I");
        arguments.add(new Path(StandardVMDebugger.getDirectoryOfRubyDebuggerFile()).toOSString());
        if (!debugTarget.isUsingDefaultPort()) {
            arguments.add("-r" + debugTarget.getDebugParameterFile().getAbsolutePath());
        }
        if (RdtDebugCorePlugin.isRubyDebuggerVerbose() || StandardVMDebugger.isDebuggerVerbose()) {
            arguments.add("-rclassic-debug-verbose");
        } else {
            arguments.add("-rclassic-debug");
        }
        return arguments;
    }

    protected static boolean isDebuggerVerbose() {
        return LaunchingPlugin.getDefault().getPluginPreferences().getBoolean("verboseDebugger");
    }

    public static String getDirectoryOfRubyDebuggerFile() {
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("classic-debug-verbose.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("classic-debug.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("context.rb"));
        File debugFile = RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("xml_printer.rb"));
        if (debugFile == null) {
            return "";
        }
        return debugFile.getParent();
    }
}

