/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.LibraryInfo;
import org.rubypeople.rdt.internal.launching.RubyContainerInitializer;
import org.rubypeople.rdt.internal.launching.RuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntryResolver2;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyVMRuntimeLoadpathEntryResolver
implements IRuntimeLoadpathEntryResolver2 {
    public IRuntimeLoadpathEntry[] resolveRuntimeLoadpathEntry(IRuntimeLoadpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IVMInstall rubyVM = null;
        rubyVM = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? RubyContainerInitializer.resolveInterpreter(entry.getPath()) : RubyRuntime.computeVMInstall(configuration);
        if (rubyVM == null) {
            return new IRuntimeLoadpathEntry[0];
        }
        return this.resolveLibraryLocations(rubyVM, entry.getLoadpathProperty());
    }

    public IRuntimeLoadpathEntry[] resolveRuntimeLoadpathEntry(IRuntimeLoadpathEntry entry, IRubyProject project) throws CoreException {
        IVMInstall rubyVM = null;
        rubyVM = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? RubyContainerInitializer.resolveInterpreter(entry.getPath()) : RubyRuntime.getVMInstall(project);
        if (rubyVM == null) {
            return new IRuntimeLoadpathEntry[0];
        }
        return this.resolveLibraryLocations(rubyVM, entry.getLoadpathProperty());
    }

    protected IRuntimeLoadpathEntry[] resolveLibraryLocations(IVMInstall vm, int kind) {
        LibraryInfo libraryInfo;
        File vmInstallLocation;
        IPath[] libs = vm.getLibraryLocations();
        IPath[] defaultLibs = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
        boolean overrideRubydoc = false;
        if (libs == null) {
            libs = defaultLibs;
            overrideRubydoc = true;
        } else if (!RubyVMRuntimeLoadpathEntryResolver.isSameArchives(libs, defaultLibs)) {
            kind = 2;
        }
        if (kind == 2 && (vmInstallLocation = vm.getInstallLocation()) != null && (libraryInfo = LaunchingPlugin.getLibraryInfo(vm.getVMInstallType(), vmInstallLocation.getAbsolutePath())) != null) {
            ArrayList<IRuntimeLoadpathEntry> resolvedEntries = new ArrayList<IRuntimeLoadpathEntry>(libs.length);
            int i = 0;
            while (i < libs.length) {
                IPath location;
                IPath libraryPath = location = libs[i];
                libraryPath.toFile().getParent();
                resolvedEntries.add(this.resolveLibraryLocation(vm, location, kind, overrideRubydoc));
                ++i;
            }
            return resolvedEntries.toArray(new IRuntimeLoadpathEntry[resolvedEntries.size()]);
        }
        ArrayList<IRuntimeLoadpathEntry> resolvedEntries = new ArrayList<IRuntimeLoadpathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            IPath systemLibraryPath = libs[i];
            if (systemLibraryPath.toFile().exists()) {
                resolvedEntries.add(this.resolveLibraryLocation(vm, libs[i], kind, overrideRubydoc));
            }
            ++i;
        }
        return resolvedEntries.toArray(new IRuntimeLoadpathEntry[resolvedEntries.size()]);
    }

    public static boolean isSameArchives(IPath[] libs, IPath[] defaultLibs) {
        if (libs.length != defaultLibs.length) {
            return false;
        }
        int i = 0;
        while (i < defaultLibs.length) {
            IPath def = defaultLibs[i];
            IPath lib = libs[i];
            if (!def.equals((Object)lib)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IVMInstall resolveVMInstall(ILoadpathEntry entry) {
        switch (entry.getEntryKind()) {
            case 4: {
                if (!entry.getPath().segment(0).equals("RUBY_LIB")) break;
                return RubyRuntime.getDefaultVMInstall();
            }
            case 5: {
                if (!entry.getPath().segment(0).equals(RubyRuntime.RUBY_CONTAINER)) break;
                return RubyContainerInitializer.resolveInterpreter(entry.getPath());
            }
        }
        return null;
    }

    public boolean isVMInstallReference(ILoadpathEntry entry) {
        switch (entry.getEntryKind()) {
            case 4: {
                if (!entry.getPath().segment(0).equals("RUBY_LIB")) break;
                return true;
            }
            case 5: {
                if (!entry.getPath().segment(0).equals(RubyRuntime.RUBY_CONTAINER)) break;
                return true;
            }
        }
        return false;
    }

    private IRuntimeLoadpathEntry resolveLibraryLocation(IVMInstall vm, IPath location, int kind, boolean overrideRubyDoc) {
        IPath libraryPath = location;
        ILoadpathEntry cpe = RubyCore.newLibraryEntry((IPath)libraryPath, (boolean)false);
        RuntimeLoadpathEntry resolved = new RuntimeLoadpathEntry(cpe);
        resolved.setLoadpathProperty(kind);
        return resolved;
    }
}

