/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyVMContainer
implements ILoadpathContainer {
    private static Map fgLoadpathEntries;
    private IVMInstall fInterpreter;
    private IPath fPath;

    public RubyVMContainer(IVMInstall interpreter, IPath path) {
        this.fInterpreter = interpreter;
        this.fPath = path;
    }

    public String getDescription() {
        return "Ruby System Library";
    }

    public ILoadpathEntry[] getLoadpathEntries() {
        return RubyVMContainer.getLoadpathEntries(this.fInterpreter);
    }

    private static ILoadpathEntry[] getLoadpathEntries(IVMInstall vm) {
        ILoadpathEntry[] entries;
        if (fgLoadpathEntries == null) {
            fgLoadpathEntries = new HashMap(10);
            IVMInstallChangedListener listener = new IVMInstallChangedListener(){

                public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
                }

                public void vmChanged(PropertyChangeEvent event) {
                    if (event.getSource() != null) {
                        fgLoadpathEntries.remove(event.getSource());
                    }
                }

                public void vmAdded(IVMInstall newVm) {
                }

                public void vmRemoved(IVMInstall removedVm) {
                    fgLoadpathEntries.remove(removedVm);
                }
            };
            RubyRuntime.addVMInstallChangedListener(listener);
        }
        if ((entries = (ILoadpathEntry[])fgLoadpathEntries.get(vm)) == null) {
            entries = RubyVMContainer.computeLoadpathEntries(vm);
            fgLoadpathEntries.put(vm, entries);
        }
        return entries;
    }

    private static ILoadpathEntry[] computeLoadpathEntries(IVMInstall vm) {
        IPath[] libs = vm.getLibraryLocations();
        if (libs == null) {
            libs = RubyRuntime.getLibraryLocations(vm);
        }
        ArrayList<ILoadpathEntry> entries = new ArrayList<ILoadpathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            entries.add(RubyCore.newLibraryEntry((IPath)libs[i], (boolean)false));
            ++i;
        }
        return entries.toArray(new ILoadpathEntry[entries.size()]);
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }
}

