/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class RubyMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    protected static final String EMPTY_STRING = "";

    protected IProject[] getProjectsForCandidate(ILaunchConfiguration candidate) throws CoreException {
        String pname = candidate.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        return new IProject[]{ResourcesPlugin.getWorkspace().getRoot().getProject(pname)};
    }

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        if (candidate.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING).equals(EMPTY_STRING)) {
            return false;
        }
        IResource[] mappedResources = candidate.getMappedResources();
        return mappedResources == null || mappedResources.length <= 0;
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        IProject[] projects = this.getProjectsForCandidate(candidate);
        ArrayList<IProject> mappings = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (!mappings.contains(projects[i])) {
                mappings.add(projects[i]);
            }
            ++i;
        }
        ILaunchConfigurationWorkingCopy wc = candidate.getWorkingCopy();
        wc.setMappedResources(mappings.toArray(new IResource[mappings.size()]));
        wc.doSave();
    }

    public static void updateResourceMapping(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        IResource resource = RubyMigrationDelegate.getResource((ILaunchConfiguration)wc);
        IResource[] resources = null;
        if (resource != null) {
            resources = new IResource[]{resource};
        }
        wc.setMappedResources(resources);
    }

    public static IResource getResource(ILaunchConfiguration candidate) throws CoreException {
        IProject resource = null;
        String pname = candidate.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        if (!EMPTY_STRING.equals(pname)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pname);
            String tname = candidate.getAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, EMPTY_STRING);
            if (!EMPTY_STRING.equals(tname)) {
                if (project != null && project.exists() && project.isOpen()) {
                    resource = project.getFile(tname);
                }
            } else {
                return project;
            }
            if (resource == null) {
                resource = project;
            }
        }
        return resource;
    }
}

