/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.rubypeople.rdt.core.LoadpathVariableInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyLoadpathVariablesInitializer
extends LoadpathVariableInitializer
implements IVMInstallChangedListener {
    private IProgressMonitor fMonitor;
    private String fVariable;

    public RubyLoadpathVariablesInitializer() {
        RubyRuntime.addVMInstallChangedListener(this);
    }

    public void initialize(String variable) {
        IPath[] systemLib;
        this.fVariable = variable;
        IVMInstall vmInstall = RubyRuntime.getDefaultVMInstall();
        if (vmInstall != null && (systemLib = RubyRuntime.getLibraryLocations(vmInstall)) != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wsDescription = workspace.getDescription();
            boolean wasAutobuild = wsDescription.isAutoBuilding();
            try {
                try {
                    this.setAutobuild(workspace, false);
                    this.setRubyVMVariable(systemLib, variable);
                }
                catch (CoreException ce) {
                    LaunchingPlugin.log(ce);
                    try {
                        this.setAutobuild(workspace, wasAutobuild);
                    }
                    catch (CoreException ce2) {
                        LaunchingPlugin.log(ce2);
                    }
                    return;
                }
            }
            finally {
                try {
                    this.setAutobuild(workspace, wasAutobuild);
                }
                catch (CoreException ce) {
                    LaunchingPlugin.log(ce);
                }
            }
        }
    }

    private void setRubyVMVariable(IPath[] newPath, String var) throws CoreException {
        RubyCore.setLoadpathVariable((String)var, (IPath[])newPath, (IProgressMonitor)this.getMonitor());
    }

    private boolean setAutobuild(IWorkspace ws, boolean newState) throws CoreException {
        IWorkspaceDescription wsDescription = ws.getDescription();
        boolean oldState = wsDescription.isAutoBuilding();
        if (oldState != newState) {
            wsDescription.setAutoBuilding(newState);
            ws.setDescription(wsDescription);
        }
        return oldState;
    }

    protected IProgressMonitor getMonitor() {
        if (this.fMonitor == null) {
            return new NullProgressMonitor();
        }
        return this.fMonitor;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        this.initialize(this.fVariable);
    }

    public void vmAdded(IVMInstall newVm) {
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmRemoved(IVMInstall removedVm) {
    }
}

