/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.LibraryInfo;
import org.rubypeople.rdt.internal.launching.RubiniusVM;
import org.rubypeople.rdt.launching.AbstractVMInstallType;
import org.rubypeople.rdt.launching.IVMInstall;

public class RubiniusVMType
extends AbstractVMInstallType {
    private static Map<String, LibraryInfo> fgFailedInstallPath = new HashMap<String, LibraryInfo>();
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateRubyFiles = new String[]{"rbx", "rubinius"};
    private static final String[] fgCandidateRubyLocations = new String[]{"", "bin" + fgSeparator, "shotgun" + fgSeparator};

    protected IVMInstall doCreateVMInstall(String id) {
        return new RubiniusVM(this, id);
    }

    public File detectInstallLocation() {
        File rubyExecutable = null;
        if (Platform.getOS().equals("win32")) {
            String winPath = System.getenv("Path");
            String[] paths = winPath.split(";");
            int i = 0;
            while (i < paths.length) {
                String possibleExecutablePath = String.valueOf(paths[i]) + File.separator + "rbx";
                File possible = new File(possibleExecutablePath);
                if (possible.exists()) {
                    rubyExecutable = possible;
                    break;
                }
                ++i;
            }
        } else {
            String[] cmdLine = new String[]{"which", "rbx"};
            rubyExecutable = this.parseRubyExecutableLocation(this.executeAndRead(cmdLine));
            if (rubyExecutable == null || rubyExecutable.getAbsolutePath().startsWith("/usr/bin")) {
                File rubyHome = this.tryLocation(new File("/usr/local/bin/rbx"));
                if (rubyHome != null) {
                    return rubyHome;
                }
                rubyHome = this.tryLocation(new File("/opt/local/bin/rbx"));
                if (rubyHome != null) {
                    return rubyHome;
                }
            }
        }
        return this.tryLocation(rubyExecutable);
    }

    private File tryLocation(File rubyExecutable) {
        if (rubyExecutable == null) {
            return null;
        }
        File bin = rubyExecutable.getParentFile();
        if (!bin.exists()) {
            return null;
        }
        File rubyHome = bin.getParentFile();
        if (!rubyHome.exists()) {
            return null;
        }
        if (!this.canDetectDefaultSystemLibraries(rubyHome, rubyExecutable)) {
            return null;
        }
        return rubyHome;
    }

    public IPath[] getDefaultLibraryLocations(File installLocation) {
        File rubyExecutable = RubiniusVMType.findRubyExecutable(installLocation);
        LibraryInfo info = rubyExecutable == null ? this.getDefaultLibraryInfo(installLocation) : this.getLibraryInfo(installLocation, rubyExecutable);
        String[] loadpath = info.getBootpath();
        IPath[] paths = new IPath[loadpath.length];
        int i = 0;
        while (i < loadpath.length) {
            paths[i] = new Path(loadpath[i]);
            ++i;
        }
        return paths;
    }

    public String getName() {
        return "Rubinius VM";
    }

    public IStatus validateInstallLocation(File rubyHome) {
        Status status = null;
        File rubyExecutable = RubiniusVMType.findRubyExecutable(rubyHome);
        status = rubyExecutable == null ? new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_Root__Java_executable_was_not_found_1, null) : (this.canDetectDefaultSystemLibraries(rubyHome, rubyExecutable) ? new Status(0, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_ok_2, null) : new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_root__System_library_was_not_found__1, null));
        return status;
    }

    public static File findRubyExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateRubyFiles.length) {
            int j = 0;
            while (j < fgCandidateRubyLocations.length) {
                File rubyFile = new File(vmInstallLocation, String.valueOf(fgCandidateRubyLocations[j]) + fgCandidateRubyFiles[i]);
                if (rubyFile.isFile()) {
                    return rubyFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected boolean canDetectDefaultSystemLibraries(File rubyHome, File rubyExecutable) {
        IPath[] locations = this.getDefaultLibraryLocations(rubyHome);
        return locations.length > 0;
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath[] dflts = this.getDefaultSystemLibrary(installLocation);
        String[] strings = new String[dflts.length];
        int i = 0;
        while (i < dflts.length) {
            strings[i] = dflts[i].toOSString();
            ++i;
        }
        return new LibraryInfo("1.8.6", strings);
    }

    protected IPath[] getDefaultSystemLibrary(File rubyHome) {
        File exe = RubiniusVMType.findRubyExecutable(rubyHome);
        if (exe != null && exe.getAbsolutePath().endsWith("shotgun" + File.separator + "rubinius")) {
            return new IPath[]{new Path(String.valueOf(rubyHome.getAbsolutePath()) + fgSeparator + "lib")};
        }
        return new IPath[]{new Path(String.valueOf(rubyHome.getAbsolutePath()) + fgSeparator + "lib" + fgSeparator + "rubinius" + fgSeparator + "1.0")};
    }

    protected synchronized LibraryInfo getLibraryInfo(File rubyHome, File rubyExecutable) {
        String installPath = rubyHome.getAbsolutePath();
        LibraryInfo info = LaunchingPlugin.getLibraryInfo(this, installPath);
        if (info == null && (info = fgFailedInstallPath.get(installPath)) == null) {
            info = this.generateLibraryInfo(rubyHome, rubyExecutable);
            if (info == null) {
                info = this.getDefaultLibraryInfo(rubyHome);
                fgFailedInstallPath.put(installPath, info);
            } else {
                LaunchingPlugin.setLibraryInfo(this, installPath, info);
            }
        }
        return info;
    }

    protected File getLibraryInfoGeneratorPath() {
        return LaunchingPlugin.getFileInPlugin(new Path("ruby").append("rubinius_vm_type").append("loadpath.rb"));
    }

    public File findExecutable(File installLocation) {
        return RubiniusVMType.findRubyExecutable(installLocation);
    }

    public String getVMPlatform(File installLocation, File executable) {
        return "rubinius";
    }
}

