/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.StandardVMRunner;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubiniusVMRunner
extends StandardVMRunner {
    @Override
    protected void addStreamSync(List<String> arguments) {
    }

    @Override
    protected List<String> constructProgramString(VMRunnerConfiguration config) throws CoreException {
        ArrayList<String> string = new ArrayList<String>();
        if (!Platform.getOS().equals("win32") && config.isSudo()) {
            this.forceBackgroundSudoCommand(config);
            string.add("sudo");
        }
        String command = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND);
        }
        if (command == null) {
            File exe = this.fVMInstance.getVMInstallType().findExecutable(this.fVMInstance.getInstallLocation());
            if (exe == null) {
                this.abort(MessageFormat.format(LaunchingMessages.StandardVMRunner_Unable_to_locate_executable_for__0__1, this.fVMInstance.getName()), null, 150);
            }
            string.add(exe.getAbsolutePath());
            return string;
        }
        String installLocation = String.valueOf(this.fVMInstance.getInstallLocation().getAbsolutePath()) + File.separatorChar;
        File exe = new File(String.valueOf(installLocation) + "bin" + File.separatorChar + command);
        if (this.fileExists(exe)) {
            string.add(exe.getAbsolutePath());
            return string;
        }
        if (this.fileExists(exe = new File(String.valueOf(exe.getAbsolutePath()) + ".exe"))) {
            string.add(exe.getAbsolutePath());
            return string;
        }
        String path = String.valueOf(installLocation) + "bin" + File.separatorChar + "j" + command;
        if (Platform.getOS().equals("win32")) {
            exe = new File(String.valueOf(path) + ".bat");
            if (this.fileExists(exe)) {
                string.add(exe.getAbsolutePath());
                return string;
            }
        } else {
            exe = new File(path);
            if (this.fileExists(exe)) {
                string.add(exe.getAbsolutePath());
                return string;
            }
        }
        this.abort(MessageFormat.format(LaunchingMessages.StandardVMRunner_Specified_executable__0__does_not_exist_for__1__4, command, this.fVMInstance.getName()), null, 150);
        return null;
    }

    @Override
    protected String[] getEnvironment(VMRunnerConfiguration config) {
        return config.getEnvironment();
    }
}

