/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.launching.AbstractRubyLaunchConfigurationDelegate;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMConnector;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RemoteRubyLaunchConfigurationDelegate
extends AbstractRubyLaunchConfigurationDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format(LaunchingMessages.RubyRemoteApplicationLaunchConfigurationDelegate_Attaching_to__0_____1, configuration.getName()), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.subTask(LaunchingMessages.RubyRemoteApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
            String connectorId = this.getVMConnectorId(configuration);
            IVMConnector connector = null;
            connector = connectorId == null ? RubyRuntime.getDefaultVMConnector() : RubyRuntime.getVMConnector(connectorId);
            if (connector == null) {
                this.abort(LaunchingMessages.RubyRemoteApplicationLaunchConfigurationDelegate_Connector_not_specified_2, null, 119);
            }
            Map argMap = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.subTask(LaunchingMessages.RubyRemoteApplicationLaunchConfigurationDelegate_Creating_source_locator____2);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            connector.connect(argMap, monitor, launch);
            if (!monitor.isCanceled()) return;
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int i = 0;
            while (i < debugTargets.length) {
                IDebugTarget target = debugTargets[i];
                if (target.canDisconnect()) {
                    target.disconnect();
                }
                ++i;
            }
            return;
        }
        finally {
            monitor.done();
        }
    }
}

