/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyInformation;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchCleaner;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LibraryInfo;
import org.rubypeople.rdt.internal.launching.RubyContainerInitializer;
import org.rubypeople.rdt.internal.launching.RubyLoadpathVariablesInitializer;
import org.rubypeople.rdt.internal.launching.VMDefinitionsContainer;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry2;
import org.rubypeople.rdt.launching.IVMConnector;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMStandin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchingPlugin
extends Plugin
implements IVMInstallChangedListener,
Preferences.IPropertyChangeListener,
IDebugEventSetListener {
    public static final String PLUGIN_ID = "org.rubypeople.rdt.launching";
    public static final String USING_INCLUDED_JRUBY = "org.rubypeople.rdt.launching.us.included.jruby";
    private HashMap<String, IConfigurationElement> fClasspathEntryExtensions = null;
    public static final String ID_EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRIES = "runtimeLoadpathEntries";
    public static final String ID_EXTENSION_POINT_VM_CONNECTORS = "vmConnectors";
    private static Map<String, LibraryInfo> fgLibraryInfoMap = null;
    private boolean fBatchingChanges = false;
    private boolean fIgnoreVMDefPropertyChangeEvents = false;
    private String fOldVMPrefString = "";
    protected static LaunchingPlugin plugin;
    private static DocumentBuilder fgXMLParser;
    private ServiceTracker fRITracker;
    private LaunchCleaner fLaunchCleaner;
    private HashMap<String, IVMConnector> fVMConnectors;
    private static final String EMPTY_STRING = "";

    public static String osDependentPath(String aPath) {
        if (Platform.getOS().equals("win32") && aPath.startsWith(File.separator)) {
            aPath = aPath.substring(1);
        }
        return aPath;
    }

    public LaunchingPlugin() {
        plugin = this;
    }

    public static LaunchingPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public static void log(IStatus status) {
        LaunchingPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        LaunchingPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, LaunchingMessages.RdtLaunchingPlugin_internalErrorOccurred, e));
    }

    public static void debug(String message) {
        if (LaunchingPlugin.getDefault().isDebugging()) {
            System.out.println(message);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fRITracker = new ServiceTracker(context, IRubyInformation.class.getName(), null);
        this.fRITracker.open();
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        RubyRuntime.addVMInstallChangedListener(this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fLaunchCleaner = new LaunchCleaner();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fLaunchCleaner);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.fRITracker.close();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fLaunchCleaner);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            RubyRuntime.removeVMInstallChangedListener(this);
            RubyRuntime.saveVMConfiguration();
            this.savePluginPreferences();
            fgXMLParser = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(RubyRuntime.PREF_VM_XML) && !this.isIgnoreVMDefPropertyChangeEvents()) {
            this.processVMPrefsChanged((String)event.getOldValue(), (String)event.getNewValue());
        }
    }

    public void setIgnoreVMDefPropertyChangeEvents(boolean ignore) {
        this.fIgnoreVMDefPropertyChangeEvents = ignore;
    }

    public boolean isIgnoreVMDefPropertyChangeEvents() {
        return this.fIgnoreVMDefPropertyChangeEvents;
    }

    protected void processVMPrefsChanged(String oldValue, String newValue) {
        VMChanges vmChanges;
        block18: {
            block19: {
                this.fBatchingChanges = true;
                vmChanges = null;
                if (newValue != null && !newValue.equals(EMPTY_STRING)) break block18;
                this.fOldVMPrefString = oldValue;
                this.fBatchingChanges = false;
                if (vmChanges == null) break block19;
                RubyRuntime.removeVMInstallChangedListener(vmChanges);
                try {
                    vmChanges.process();
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            return;
        }
        try {
            IVMInstall newDefaultVM;
            String newPrefString;
            String oldPrefString;
            if (oldValue == null || oldValue.equals(EMPTY_STRING)) {
                oldPrefString = this.fOldVMPrefString;
                newPrefString = newValue;
            } else {
                oldPrefString = oldValue;
                newPrefString = newValue;
            }
            vmChanges = new VMChanges();
            RubyRuntime.addVMInstallChangedListener(vmChanges);
            VMDefinitionsContainer oldResults = this.getVMDefinitions(oldPrefString);
            VMDefinitionsContainer newResults = this.getVMDefinitions(newPrefString);
            List<IVMInstall> deleted = oldResults.getVMList();
            List<IVMInstall> current = newResults.getValidVMList();
            deleted.removeAll(current);
            for (VMStandin vMStandin : deleted) {
                vMStandin.getVMInstallType().disposeVMInstall(vMStandin.getId());
            }
            for (VMStandin vMStandin : current) {
                vMStandin.convertToRealVM();
            }
            String string = newResults.getDefaultVMInstallCompositeID();
            if (string != null && (newDefaultVM = RubyRuntime.getVMFromCompositeId(string)) != null) {
                try {
                    RubyRuntime.setDefaultVMInstall(newDefaultVM, null, false);
                }
                catch (CoreException ce) {
                    LaunchingPlugin.log(ce);
                }
            }
        }
        catch (Throwable throwable) {
            this.fBatchingChanges = false;
            if (vmChanges != null) {
                RubyRuntime.removeVMInstallChangedListener(vmChanges);
                try {
                    vmChanges.process();
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            throw throwable;
        }
        this.fBatchingChanges = false;
        if (vmChanges != null) {
            RubyRuntime.removeVMInstallChangedListener(vmChanges);
            try {
                vmChanges.process();
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    private VMDefinitionsContainer getVMDefinitions(String xml) {
        if (xml.length() > 0) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF8"));
                return VMDefinitionsContainer.parseXMLIntoContainer(stream);
            }
            catch (IOException e) {
                LaunchingPlugin.log(e);
            }
        }
        return new VMDefinitionsContainer();
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static void log(String message) {
        LaunchingPlugin.log((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static DocumentBuilder getParser() throws CoreException {
        if (fgXMLParser == null) {
            try {
                fgXMLParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                fgXMLParser.setErrorHandler(new DefaultHandler());
            }
            catch (ParserConfigurationException e) {
                LaunchingPlugin.abort(LaunchingMessages.LaunchingPlugin_33, e);
            }
            catch (FactoryConfigurationError e) {
                LaunchingPlugin.abort(LaunchingMessages.LaunchingPlugin_34, e);
            }
        }
        return fgXMLParser;
    }

    protected static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, message, exception);
        throw new CoreException((IStatus)status);
    }

    public static void setLibraryInfo(IVMInstallType type, String installPath, LibraryInfo info) {
        if (fgLibraryInfoMap == null) {
            LaunchingPlugin.restoreLibraryInfo();
        }
        if (info == null) {
            fgLibraryInfoMap.remove(LaunchingPlugin.buildLibraryInfoKey(type, installPath));
        } else {
            fgLibraryInfoMap.put(LaunchingPlugin.buildLibraryInfoKey(type, installPath), info);
        }
        LaunchingPlugin.saveLibraryInfo();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveLibraryInfo() {
        FileOutputStream stream = null;
        try {
            String xml = LaunchingPlugin.getLibraryInfoAsXML();
            IPath libPath = LaunchingPlugin.getDefault().getStateLocation();
            libPath = libPath.append("libraryInfos.xml");
            File file = libPath.toFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            stream = new FileOutputStream(file);
            stream.write(xml.getBytes("UTF8"));
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
            if (stream == null) return;
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (ParserConfigurationException e) {
            LaunchingPlugin.log(e);
            if (stream == null) return;
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (TransformerException e) {
            LaunchingPlugin.log(e);
            if (stream == null) return;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (stream == null) return;
        try {
            stream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private static String getLibraryInfoAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = LaunchingPlugin.getDocument();
        Element config = doc.createElement("libraryInfos");
        doc.appendChild(config);
        for (String raw : fgLibraryInfoMap.keySet()) {
            int index = raw.indexOf(";");
            String home = raw.substring(index + 1);
            String vmTypeId = "org.rubypeople.rdt.launching.StandardVMType";
            if (index != -1) {
                vmTypeId = raw.substring(0, index);
            }
            LibraryInfo info = fgLibraryInfoMap.get(raw);
            Element locationElemnet = LaunchingPlugin.infoAsElement(doc, info);
            locationElemnet.setAttribute("home", home);
            locationElemnet.setAttribute("vmTypeId", vmTypeId);
            config.appendChild(locationElemnet);
        }
        return LaunchingPlugin.serializeDocument(doc);
    }

    private static Element infoAsElement(Document doc, LibraryInfo info) {
        Element libraryElement = doc.createElement("libraryInfo");
        libraryElement.setAttribute("version", info.getVersion());
        LaunchingPlugin.appendPathElements(doc, "bootpath", libraryElement, info.getBootpath());
        return libraryElement;
    }

    private static void appendPathElements(Document doc, String elementType, Element libraryElement, String[] paths) {
        if (paths.length > 0) {
            Element child = doc.createElement(elementType);
            libraryElement.appendChild(child);
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                Element entry = doc.createElement("entry");
                child.appendChild(entry);
                entry.setAttribute("path", path);
                ++i;
            }
        }
    }

    public static LibraryInfo getLibraryInfo(IVMInstallType type, String vmInstallPath) {
        if (fgLibraryInfoMap == null) {
            LaunchingPlugin.restoreLibraryInfo();
        }
        return fgLibraryInfoMap.get(LaunchingPlugin.buildLibraryInfoKey(type, vmInstallPath));
    }

    private static String buildLibraryInfoKey(IVMInstallType type, String vmInstallPath) {
        return LaunchingPlugin.buildLibraryInfoKey(type.getId(), vmInstallPath);
    }

    private static String buildLibraryInfoKey(String vmTypeId, String vmInstallPath) {
        return String.valueOf(vmTypeId) + ";" + vmInstallPath;
    }

    private static void restoreLibraryInfo() {
        fgLibraryInfoMap = new HashMap<String, LibraryInfo>(10);
        IPath libPath = LaunchingPlugin.getDefault().getStateLocation();
        File file = (libPath = libPath.append("libraryInfos.xml")).toFile();
        if (file.exists()) {
            try {
                FileInputStream stream = new FileInputStream(file);
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                Element root = parser.parse(new InputSource(stream)).getDocumentElement();
                if (!root.getNodeName().equals("libraryInfos")) {
                    return;
                }
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element element;
                    String nodeName;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase("libraryInfo")) {
                        String version = element.getAttribute("version");
                        String location = element.getAttribute("home");
                        String vmTypeId = element.getAttribute("vmTypeId");
                        String[] bootpath = LaunchingPlugin.getPathsFromXML(element, "bootpath");
                        if (location != null) {
                            LibraryInfo info = new LibraryInfo(version, bootpath);
                            fgLibraryInfoMap.put(LaunchingPlugin.buildLibraryInfoKey(vmTypeId, location), info);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                LaunchingPlugin.log(e);
            }
            catch (ParserConfigurationException e) {
                LaunchingPlugin.log(e);
            }
            catch (SAXException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    private static String[] getPathsFromXML(Element lib, String pathType) {
        ArrayList<String> paths = new ArrayList<String>();
        NodeList list = lib.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            String nodeName;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase(pathType)) {
                NodeList entries = element.getChildNodes();
                int numEntries = entries.getLength();
                int j = 0;
                while (j < numEntries) {
                    String path;
                    Element entryElement;
                    String name;
                    Node n = entries.item(j);
                    short t = n.getNodeType();
                    if (t == 1 && (name = (entryElement = (Element)n).getNodeName()).equals("entry") && (path = entryElement.getAttribute("path")) != null && path.length() > 0) {
                        paths.add(path);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public IRuntimeLoadpathEntry2 newRuntimeLoadpathEntry(String id) throws CoreException {
        IConfigurationElement config;
        if (this.fClasspathEntryExtensions == null) {
            this.initializeRuntimeLoadpathExtensions();
        }
        if ((config = this.fClasspathEntryExtensions.get(id)) == null) {
            LaunchingPlugin.abort(MessageFormat.format(LaunchingMessages.LaunchingPlugin_32, id), null);
        }
        return (IRuntimeLoadpathEntry2)config.createExecutableExtension("class");
    }

    private void initializeRuntimeLoadpathExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ID_EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRIES);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        this.fClasspathEntryExtensions = new HashMap(configs.length);
        int i = 0;
        while (i < configs.length) {
            this.fClasspathEntryExtensions.put(configs[i].getAttribute("id"), configs[i]);
            ++i;
        }
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        if (!this.fBatchingChanges) {
            try {
                VMChanges changes = new VMChanges();
                changes.defaultVMInstallChanged(previous, current);
                changes.process();
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    public void vmAdded(IVMInstall newVm) {
    }

    public void vmChanged(PropertyChangeEvent event) {
        if (!this.fBatchingChanges) {
            try {
                VMChanges changes = new VMChanges();
                changes.vmChanged(event);
                changes.process();
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    public void vmRemoved(IVMInstall vm) {
        this.removeCoreStubs(vm);
        if (!this.fBatchingChanges) {
            try {
                VMChanges changes = new VMChanges();
                changes.vmRemoved(vm);
                changes.process();
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    private void removeCoreStubs(IVMInstall vm) {
        IPath coreStubPath = this.getStateLocation().append(vm.getId());
        this.deleteRecursively(coreStubPath.toFile());
    }

    private void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteRecursively(children[i]);
                ++i;
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static File getFileInPlugin(IPath path) {
        return RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)path);
    }

    public static void info(String string) {
        LaunchingPlugin.log((IStatus)new Status(1, PLUGIN_ID, -1, string, null));
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IProcess iProc;
            String refresh;
            int kind = events[i].getKind();
            Object source = events[i].getSource();
            if (kind == 8 && source instanceof IProcess && (refresh = (iProc = (IProcess)source).getAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH)) != null && refresh.equals("true")) {
                String projName = iProc.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME);
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
                try {
                    proj.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            ++i;
        }
    }

    public static IRubyInformation getRubyInformation() {
        return (IRubyInformation)LaunchingPlugin.getDefault().fRITracker.getService();
    }

    public IVMConnector getVMConnector(String id) {
        if (this.fVMConnectors == null) {
            this.initializeVMConnectors();
        }
        return this.fVMConnectors.get(id);
    }

    public IVMConnector[] getVMConnectors() {
        if (this.fVMConnectors == null) {
            this.initializeVMConnectors();
        }
        return this.fVMConnectors.values().toArray(new IVMConnector[this.fVMConnectors.size()]);
    }

    private void initializeVMConnectors() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ID_EXTENSION_POINT_VM_CONNECTORS);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(LaunchingPlugin.getUniqueIdentifier(), 0, "Exception occurred reading vmConnectors extensions.", null);
        this.fVMConnectors = new HashMap(configs.length);
        int i = 0;
        while (i < configs.length) {
            try {
                IVMConnector vmConnector = (IVMConnector)configs[i].createExecutableExtension("class");
                this.fVMConnectors.put(vmConnector.getIdentifier(), vmConnector);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            LaunchingPlugin.log((IStatus)status);
        }
    }

    public static void logInfo(String msg) {
        LaunchingPlugin.log((IStatus)new Status(1, PLUGIN_ID, -1, msg, null));
    }

    class RubyVMUpdateJob
    extends Job {
        private VMChanges fChanges;

        public RubyVMUpdateJob(VMChanges changes) {
            super(LaunchingMessages.LaunchingPlugin_1);
            this.fChanges = changes;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.fChanges.doit(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }

    class VMChanges
    implements IVMInstallChangedListener {
        private boolean fDefaultChanged = false;
        private HashMap<IPath, IPath> fRenamedContainerIds = new HashMap();

        VMChanges() {
        }

        private IPath getContainerId(IVMInstall vm) {
            String name;
            if (vm != null && (name = vm.getName()) != null) {
                Path path = new Path(RubyRuntime.RUBY_CONTAINER);
                path = path.append((IPath)new Path(vm.getVMInstallType().getId()));
                path = path.append((IPath)new Path(name));
                return path;
            }
            return null;
        }

        public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
            this.fDefaultChanged = true;
        }

        public void vmAdded(IVMInstall vm) {
        }

        public void vmChanged(PropertyChangeEvent event) {
            String property = event.getProperty();
            IVMInstall vm = (IVMInstall)event.getSource();
            if (property.equals(IVMInstallChangedListener.PROPERTY_NAME)) {
                IPath newId = this.getContainerId(vm);
                Path oldId = new Path(RubyRuntime.RUBY_CONTAINER);
                oldId = oldId.append(vm.getVMInstallType().getId());
                String oldName = (String)event.getOldValue();
                if (oldName != null) {
                    oldId = oldId.append(oldName);
                    this.fRenamedContainerIds.put((IPath)oldId, newId);
                }
            }
        }

        public void vmRemoved(IVMInstall vm) {
        }

        public void process() throws CoreException {
            RubyVMUpdateJob job = new RubyVMUpdateJob(this);
            job.schedule();
        }

        protected void doit(IProgressMonitor monitor) throws CoreException {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor1) throws CoreException {
                    IRubyProject[] projects = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getRubyProjects();
                    monitor1.beginTask(LaunchingMessages.LaunchingPlugin_0, projects.length + 1);
                    VMChanges.this.rebind(monitor1, projects);
                    monitor1.done();
                }
            };
            RubyCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)monitor);
        }

        private void rebind(IProgressMonitor monitor, IRubyProject[] projects) throws CoreException {
            if (this.fDefaultChanged) {
                RubyLoadpathVariablesInitializer initializer = new RubyLoadpathVariablesInitializer();
                initializer.initialize("RUBY_LIB");
            }
            monitor.worked(1);
            int i = 0;
            while (i < projects.length) {
                IRubyProject project = projects[i];
                ILoadpathEntry[] entries = project.getRawLoadpath();
                boolean replace = false;
                int j = 0;
                while (j < entries.length) {
                    ILoadpathEntry entry = entries[j];
                    switch (entry.getEntryKind()) {
                        case 5: {
                            ILoadpathEntry newEntry;
                            IPath renamed;
                            IPath reference = entry.getPath();
                            IPath newBinding = null;
                            String firstSegment = reference.segment(0);
                            if (!RubyRuntime.RUBY_CONTAINER.equals(firstSegment)) break;
                            if (reference.segmentCount() > 1 && (renamed = this.fRenamedContainerIds.get(reference)) != null) {
                                newBinding = renamed;
                            }
                            RubyContainerInitializer initializer = new RubyContainerInitializer();
                            if (newBinding == null) {
                                initializer.initialize(reference, project);
                                break;
                            }
                            entries[j] = newEntry = RubyCore.newContainerEntry((IPath)newBinding, (boolean)entry.isExported());
                            replace = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (replace) {
                    project.setRawLoadpath(entries, null);
                }
                monitor.worked(1);
                ++i;
            }
        }
    }
}

