/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.rubypeople.rdt.core.SocketUtil;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.launching.JRubyVMRunner;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.RDebugVMDebugger;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyDebugVMDebugger
extends JRubyVMRunner
implements IVMRunner {
    private static final String PORT_SWITCH = "--port";
    private static final String VERBOSE_FLAG = "-d";
    private static final String RDEBUG_EXECUTABLE = "rdebug-ide";

    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.StandardVMDebugger_Launching_VM____1, 4);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Finding_free_socket____2);
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(LaunchingMessages.StandardVMDebugger_Could_not_find_a_free_socket_for_the_debugger_1, null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Constructing_command_line____3);
        RubyDebugTarget debugTarget = new RubyDebugTarget(launch, port);
        List<String> arguments = this.constructProgramString(config);
        arguments.addAll(this.debugSpecificVMArgs(debugTarget));
        String[] allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        String[] cp = config.getLoadPath();
        if (cp.length > 0) {
            arguments.addAll(this.convertLoadPath(config, cp));
        }
        arguments.addAll(this.debugArgs(debugTarget));
        arguments.add("--");
        arguments.add(this.getFileToLaunch(config));
        this.addArguments(config.getProgramArguments(), arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        String[] envp = this.getEnvironment(config);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Starting_virtual_machine____4);
        Process p = null;
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.getWorkingDir(config);
        p = this.exec(cmdLine, workingDir, envp);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = this.newProcess(launch, p, JRubyDebugVMDebugger.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
        String commandLine = JRubyDebugVMDebugger.renderCommandLine(cmdLine);
        LaunchingPlugin.debug("Starting: " + commandLine);
        process.setAttribute(IProcess.ATTR_CMDLINE, commandLine);
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Establishing_debug_connection____5);
        debugTarget.setProcess(process);
        RubyDebuggerProxy proxy = this.getDebugProxy(debugTarget);
        try {
            proxy.start();
            launch.addDebugTarget((IDebugTarget)debugTarget);
        }
        catch (IOException iOException) {
            LaunchingPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.launching", 4, LaunchingMessages.RdtLaunchingPlugin_processTerminatedBecauseNoDebuggerConnection, null));
            debugTarget.terminate();
        }
        catch (RubyProcessingException e) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_connect_to_VM_5, e, 120);
            debugTarget.terminate();
        }
    }

    protected List<String> debugSpecificVMArgs(RubyDebugTarget debugTarget) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--debug");
        return arguments;
    }

    protected List<String> debugArgs(RubyDebugTarget debugTarget) {
        ArrayList<String> arguments = new ArrayList<String>();
        String rdebug = RDebugVMDebugger.findRDebugExecutable(this.fVMInstance.getInstallLocation());
        arguments.add(rdebug);
        arguments.add(PORT_SWITCH);
        arguments.add(Integer.toString(debugTarget.getPort()));
        if (JRubyDebugVMDebugger.isDebuggerVerbose()) {
            arguments.add(VERBOSE_FLAG);
        }
        return arguments;
    }

    protected static boolean isDebuggerVerbose() {
        return LaunchingPlugin.getDefault().getPluginPreferences().getBoolean("verboseDebugger");
    }

    protected RubyDebuggerProxy getDebugProxy(RubyDebugTarget debugTarget) {
        return new RubyDebuggerProxy((IRubyDebugTarget)debugTarget, true);
    }
}

