/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.debug.ui.launcher.RubyApplicationShortcut;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.testunit.launcher.TestUnitLaunchConfigurationDelegate;

public class TestUnitLaunchShortcut
extends RubyApplicationShortcut {
    protected void doLaunch(IRubyElement rubyElement, String mode) throws CoreException {
        String container = this.getContainer(rubyElement);
        ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(rubyElement, mode, container, "", "");
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(IRubyElement rubyElement, String mode, String container, String testClass, String testName) throws CoreException {
        IFile rubyFile = (IFile)rubyElement.getUnderlyingResource();
        ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = null;
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (config.getAttribute("org.rubypeople.rdt.testunit.CONTAINER", "").equals(container) && config.getAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "").equals("") && config.getAttribute("org.rubypeople.rdt.testunit.TESTNAME", "").equals(testName) && config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(rubyFile.getProject().getName())) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createConfiguration(rubyFile, container, testName);
            }
            case 1: {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(TestUnitMessages.LaunchTestAction_message_selectConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(TestUnitMessages.LaunchTestAction_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(TestUnitMessages.LaunchTestAction_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getShell() {
        return TestunitPlugin.getActiveWorkbenchShell();
    }

    private String getContainer(IRubyElement rubyElement) {
        return rubyElement.getHandleIdentifier();
    }

    protected ILaunchConfiguration createConfiguration(IFile rubyFile, String container, String testName) {
        return this.createConfiguration(rubyFile.getLocation().toOSString(), container, rubyFile.getProject(), testName);
    }

    protected ILaunchConfiguration createConfiguration(String rubyFile, String container, IProject project, String testName) {
        if (RubyRuntime.getDefaultVMInstall() == null) {
            this.showNoInterpreterDialog();
            return null;
        }
        String[] commonLoadPathFolders = new String[]{"lib", "test"};
        ArrayList<String> loadpath = new ArrayList<String>();
        try {
            int i = 0;
            while (i < commonLoadPathFolders.length) {
                if (project.getFolder(commonLoadPathFolders[i]).exists()) {
                    IRuntimeLoadpathEntry entry = RubyRuntime.newArchiveRuntimeLoadpathEntry((IPath)project.getLocation().append(commonLoadPathFolders[i]));
                    loadpath.add(entry.getMemento());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(rubyFile));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, TestUnitLaunchConfigurationDelegate.getTestRunnerPath());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, TestUnitLaunchShortcut.getDefaultWorkingDirectory(project));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute("org.rubypeople.rdt.testunit.CONTAINER", container);
            wc.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", testName);
            wc.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "");
            if (loadpath != null && !loadpath.isEmpty()) {
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_DEFAULT_LOADPATH, false);
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_LOADPATH, loadpath);
            }
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            this.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.rubypeople.rdt.testunit.launchconfig");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void log(String message) {
        TestunitPlugin.log((IStatus)new Status(1, "org.rubypeople.rdt.testunit", 1, message, null));
    }

    protected void log(Throwable t) {
        TestunitPlugin.log(t);
    }

    protected void showNoInterpreterDialog() {
        MessageDialog.openInformation((Shell)TestunitPlugin.getActiveWorkbenchShell(), (String)TestUnitMessages.Dialog_launchWithoutSelectedInterpreter_title, (String)TestUnitMessages.Dialog_launchWithoutSelectedInterpreter);
    }

    protected static String getDefaultWorkingDirectory(IProject project) {
        if (project != null && project.exists()) {
            return project.getLocation().toOSString();
        }
        return TestunitPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }
}

